/* $Id: glue-main.c 4321 2009-01-27 13:02:52Z potyra $ 
 * Tiny reimplementation of time_virt() and time_call_at()
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-main.h"
#include <assert.h>
#include <stdint.h>
#include <string.h>
#include <stdbool.h>

int failure = 0;
static int64_t simulation_time = 0;
static bool terminate = false;

static struct {
	unsigned int n_calls;
	struct {
		void (*func)(void *data);
		void *data;
		int64_t tsc;
	} calls[10];
} time_calls;

int64_t
time_virt(void)
{
	return simulation_time;
}

void
time_call_at(int64_t tsc, void (*func)(void *data), void *data)
{
	assert(time_calls.n_calls < 10);

	time_calls.calls[time_calls.n_calls].func = func;
	time_calls.calls[time_calls.n_calls].data = data;
	time_calls.calls[time_calls.n_calls].tsc = tsc;
	time_calls.n_calls++;
}

/** enter the main event loop.
 *  May not be called anywhere in the library, as it's not part of
 *  the standard glue-main.
 *  -> only useful in interpreter.c which ships it's own "main"
 */
int
main_event_loop(void)
{
	while (! terminate) {
		unsigned int i;
		int entry = -1;
		int64_t min_time = INT64_MAX;

		if (time_calls.n_calls == 0) {
			break;
		}
		
		for (i = 0; i < time_calls.n_calls; i++) {
			if (time_calls.calls[i].tsc <= min_time) {
				min_time = time_calls.calls[i].tsc;
				entry = i;
			}
		}

		assert(entry != -1);
		simulation_time = min_time;
		time_calls.calls[entry].func(time_calls.calls[entry].data);
		
		/* remove entry from queue */
		for (i = entry + 1; i < time_calls.n_calls; i++) {
			time_calls.calls[i - 1].func = 
				time_calls.calls[i].func;
			time_calls.calls[i - 1].data = 
				time_calls.calls[i].data;
			time_calls.calls[i - 1].tsc = time_calls.calls[i].tsc;
		}
		time_calls.n_calls--;
	}

	return failure;
}

void
frontend_quit(void)
{
	terminate = true;
}
