/* $Id: interpreter.c 4321 2009-01-27 13:02:52Z potyra $
 * Main interpreter program.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <stdio.h>
#include <unistd.h>
#include <assert.h>
#define _GNU_SOURCE
#include <getopt.h>
#undef _GNU_SOURCE
#include "libfauhdli.h"

/* from glue-main only for this file. */
extern int
main_event_loop(void);

/** run self-tests of data structures for sanity. */
static void
run_test_suite(void)
{
	slset_self_test();
}

static int
run_fauhdli(
	const char *parse_file, 
	const char *top_entity, 
	const char *trace_file,
	bool debug
)
{
	struct fauhdli *instance;
	int ret;

	instance = fauhdli_create(parse_file, trace_file, debug);
	fauhdli_init(instance, top_entity);
	ret = main_event_loop();
	fauhdli_destroy(instance);

	return ret;
}

static void
usage(void)
{
	fprintf(stderr, "fauhdli [options] FILE\n");
	fprintf(stderr, "  Interprete commands from FILE.\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "  -s ENTITY, --simulate=ENTITY   Start simulation "
			"with ENTITY as top entity.\n");
	fprintf(stderr, "  -o VCDFILE, --output=VCDFILE   Output trace to ");
	fprintf(stderr, "VCDFILE.\n");
	fprintf(stderr, "  -t, --test                     run self tests\n");
	fprintf(stderr, "  -d, --debug                    enable debug "
			"output\n");
	fprintf(stderr, "\n");
}

int
main(int argc, char **argv)
{
	const char *parse_file = NULL;
	const char *top_entity = NULL;
	const char *trace_file = NULL;
	int c;
	bool debug = false;
	int ret;
	struct option l_opts[] = {
		{"simulate", 1, NULL, 's'},
		{"test", 0, NULL, 't'},
		{"output", 1, NULL, 'o'},
		{"debug", 0, NULL, 'o'},
		{0, 0, 0, 0}
	};

	for (;;) {
		c = getopt_long(argc, argv, "s:to:d", l_opts, NULL);
		if (c == -1) {
			break;
		}

		switch (c) {
		case 's':
			top_entity = optarg;
			break;

		case 'o':
			trace_file = optarg;
			break;

		case 't':
			run_test_suite();
			return EXIT_SUCCESS;

		case 'd':
			debug = true;
			break;

		default:
			usage();
			return EXIT_FAILURE;
		}
	}

	if (argc - optind != 1) {
		usage();
		return EXIT_FAILURE;
	}

	parse_file = argv[optind];
	ret = run_fauhdli(parse_file, top_entity, trace_file, debug);
	
	return ret;
}
