#!/bin/sh
# $Id: install_ln.sh 4325 2009-01-27 14:02:16Z potyra $
#
# mimic install but use soft links instead
#
# Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.


if [ $1 = '-c' ]; then
	# -c -> ignored
	shift
fi

if [ $1 = '-m' ]; then
	# mode -> ignore
	shift
	shift
fi

SRC=$1
shift
TRG=$1

if [ ! -e "$SRC" ]; then
	echo "$SRC no such file or directory."
	exit 1
fi

if [ -e "$TRG" -a \( ! \( -h "$TRG" \) \) ]; then
	echo "$TRG exists and is not a symbolic link."
fi

TRGDIR=$(dirname "$TRG")
mkdir -p "$TRGDIR"
ln -sf "$(pwd)/$SRC" "$TRG"
