/* $Id: PhysicalType.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/PhysicalType.hpp"
#include "frontend/ast/PhysicalTypeUnit.hpp"

namespace ast {

PhysicalType::PhysicalType(
	std::string* declName,
	DiscreteRange* range,
	std::list<PhysicalTypeUnit*>* assocUnits,
	Location loc
	) : 	TypeDeclaration(declName, loc, BASE_TYPE_INTEGER),
		constraint(range),
		units(assocUnits) {

	// set parent of each unit.
	for (std::list<PhysicalTypeUnit*>::iterator i = this->units->begin();
		i != this->units->end(); i++) {

		(*i)->parent = this;
	}
		
}

PhysicalType::~PhysicalType() 
{
	util::MiscUtil::terminate(constraint);
	util::MiscUtil::lterminate(units);
}

}; /* namespace ast */
