-- $Id: test_indices.vhdl 4326 2009-01-27 14:37:19Z potyra $ 

-- type resolution for function calls returning arrays and its index
-- constraints. Only the prefix of an indexed name must be an array type,
-- but it seems that the index types mustn't be used to disambiguate
-- the prefix.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package decls is
	type foo is range 1 to 10;
	type bar is range 1 to 20;
	type x is array(foo) of integer;
	type y is array(bar) of integer;
	function f(a: integer) return x;
	function f(a: integer) return y;
end package decls;

package body decls is
	function f(a: integer) return x is
		variable r : x;
	begin
		r(1) := a;
		return r;
	end;

	function f(a: integer) return y is
		variable r : y;
	begin
		r(1) := a;
		return r;
	end;
end decls;


entity e is 
end entity e;

use decls.all;
architecture a of e is
begin
	p : process
		variable a : foo;
		variable b : bar;
		variable i : integer;
		variable j : integer;
	begin
		j := 1;
		i := f(j)(a); -- @ERROR@ Ambiguous Types
		i := f(j)(b); -- @ERROR@ Ambiguous Types
	end process p;
end architecture a;
