/* $Id: Name.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/Name.hpp"
#include "frontend/misc/Symbol.hpp"

namespace ast {

std::string
Name::getName(void) const throw(std::logic_error)
{
	if (this->candidates.size() != 1) {
		throw std::logic_error(
			"getName() called, but definition is unclear.");
	}

	Symbol *sym = this->candidates.front();
	return sym->declaration.getICName();

}

SymbolDeclaration*
Name::getDeclaration(void) const
{
	assert(this->candidates.size() == 1);
	Symbol *sym = this->candidates.front();
	return &sym->declaration;
}

}; /* namespace ast */
