/* $Id: LabelFactory.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LABEL_FACTORY_HPP_INCLUDED
#define __LABEL_FACTORY_HPP_INCLUDED

#include "intermediate/container/Label.hpp"

namespace intermediate {

//! produce uniquely named labels.
class LabelFactory {
public:
	//! get a label with prefix prefix
	/** @param prefix desired prefix of the label.
	 *  @return Label with a unique name.
	 */
	static Label *getLabel(const char *prefix);

	//! get a label with a fixed name.
	/** No checks are performed, if this label is unique.
	 *  @param name desired name of the label.
	 *  @return Label with the requested name.
	 */
	static Label *getFixedLabel(const char *name);

	//! get a label with a fixed name.
	/** No checks are performed, if this label is unique.
	 *  @param name desired name of the label.
	 *  @return Label with the requested name.
	 */
	static Label *getFixedLabel(const std::string &name);

	//! get a label pointing to an unparametrized error function.
	/** Use this method to get a lable that can be jumped to in case 
	 *  an error occurs (e.g. constraint violations etc.)
	 */
	static Label *getErrorLabel(void);
private:
	// internal Label counter
	static int cnt;
};

}; /* namespace intermediate */

#endif /* __LABEL_FACTORY_HPP_INCLUDED */
