/* $Id: arch_gen_cpu_x86_core.c,v 1.31 2009-01-28 12:59:15 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * 8-3
 */
static void
NAME_(core_do_reset)(int reset_flag)
{
	int i;

	if (reset_flag) {
		NAME_(jit_buffer_reset)();
		NAME_(jit_compile_reset)();
		NAME_(apic_reset)();
		NAME_(mmu_reset)();
	}

	env->hflags = 0;
#if 80386 <= CONFIG_CPU
	if (! env->apic.bsp) {
		env->hflags |= HF_WAITING_FOR_STARTUP_MASK;
	}
#endif

	/*
	 * must do it in this sequence:
	 * - first initialize real-mode (cr0)
	 * - then initialize segment registers
	 */
	env->eflags = 0x00000002; /* reserved bit */
	env->cc_src = env->eflags
		& (CC_O | CC_S | CC_Z | CC_A | CC_P | CC_C);
	env->df = 1 - (2 * ((env->eflags >> 10) & 1));
	env->cc_op = CC_OP_EFLAGS;
	env->eflags
		&= ~(CPU_DF_MASK | CC_O | CC_S | CC_Z | CC_A | CC_P | CC_C);

	NAME_(update_cr0)(0x60000010);	/* write through */
						/* caching disabled */
						/* reserved bit */
	/* NAME_(update_cr2)(0x00000000); */
	NAME_(update_cr3)(0x00000000);
	NAME_(update_cr4)(0x00000000);

	env->exception_index = -1;
	if (reset_flag) {
		env->interrupt_request = 0;
	}

	/* code segment register */
#if CONFIG_CPU <= 80286
	cpu_x86_load_seg_cache(R_CS, 0xf000, 0x000f0000, 0xffff, 0);
#else
	cpu_x86_load_seg_cache(R_CS, 0xf000, 0xffff0000, 0xffff, 0);
#endif

	/* instruction pointer */
	env->eip = 0x0000fff0;

	/* other segment registers */
	cpu_x86_load_seg_cache(R_DS, 0, 0, 0xffff, 0);
	cpu_x86_load_seg_cache(R_ES, 0, 0, 0xffff, 0);
	cpu_x86_load_seg_cache(R_SS, 0, 0, 0xffff, 0);
	cpu_x86_load_seg_cache(R_FS, 0, 0, 0xffff, 0);
	cpu_x86_load_seg_cache(R_GS, 0, 0, 0xffff, 0);

	/* edx - depends on processor version - FIXME VOSSI */
	env->regs[R_EDX] = 0x00000600; /* indicate P6 processor */

	/* eax - should contain BIST code - FIXME VOSSI */
	env->regs[R_EAX] = 0x00000000;

	/* other registers */
	env->regs[R_EBX] = 0x00000000;
	env->regs[R_ECX] = 0x00000000;
	env->regs[R_ESI] = 0x00000000;
	env->regs[R_EDI] = 0x00000000;
	env->regs[R_EBP] = 0x00000000;
	env->regs[R_ESP] = 0x00000000;

	if (reset_flag) {
		/* FPU init */
		env->fpstt = 0;
		env->fpus = 0;
		env->fpuc = 0x37f;
		for (i = 0; i < 8; i++) {
			env->fptags[i] = 1;
		}
		env->mxcsr = 0;
		memset(env->xmm_regs, 0, sizeof(env->xmm_regs));
		memset(&env->xmm_t0, 0, sizeof(env->xmm_t0));
		memset(&env->mmx_t0, 0, sizeof(env->mmx_t0));
	}

	/* gdtr, idtr */
	env->gdt.base = 0x00000000;
	env->gdt.limit = 0xffff;
	env->idt.base = 0x00000000;
	env->idt.limit = 0xffff;

	/* ldtr, task register */
	env->ldt.base = 0x00000000;
	env->ldt.limit = 0xffff;
	env->ldt.flags = DESC_P_MASK;

	env->tr.base = 0x00000000;
	env->tr.limit = 0xffff;
	env->tr.flags = DESC_P_MASK;

	/* dr0 - dr3 */
	env->dr[0] = 0;
	env->dr[1] = 0;
	env->dr[2] = 0;
	env->dr[3] = 0;

	/* dr6 */
	env->dr[6] = 0;

	/* dr7 */
	env->dr[7] = 0;

	/* time-stamp counter */
	/* FIXME */

	/* perf. counters and event select */
	/* FIXME VOSSI */

	/* all other MSRs */
#if CONFIG_CPU >= 80486 && CONFIG_CPU_SEP_SUPPORT
	env->sysenter_cs = 0;
	env->sysenter_esp = 0;
	env->sysenter_eip = 0;
#endif
	env->efer = 0;
	env->star = 0;
#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
	env->lstar = 0;
	env->cstar = 0;
	env->fmask = 0;
	env->kernelgsbase = 0;
#endif
	memset(env->msr, 0, sizeof(env->msr));

	/* fixed MTRRs */
	/* FIXME VOSSI */

	/* variable MTRRs */
	/* FIXME VOSSI */

#if 80486 <= CONFIG_CPU && CONFIG_CPU_PAT_SUPPORT
	/* PAT Table */
	env->pat[0] = 6; /* Write back */
	env->pat[1] = 4; /* Write through */
	env->pat[2] = 7; /* Uncached */
	env->pat[3] = 0; /* Uncacheable */
	env->pat[4] = 6; /* Write back */
	env->pat[5] = 4; /* Write through */
	env->pat[6] = 7; /* Uncached */
	env->pat[7] = 0; /* Uncacheable */
#endif

	/* machine-check architecture */
	/* FIXME VOSSI */

	/* System Management */
	if (reset_flag) {
		env->smbase = 0x30000;
	}
	env->smm = 0;

	/* APIC */
	/* FIXME VOSSI */
}

void
NAME_(core_reset)(void)
{
	NAME_(core_do_reset)(1);
}

void
NAME_(core_init)(void)
{
	NAME_(core_do_reset)(0);
}

void
NAME_(core_startup)(uint8_t vector)
{
	fprintf(stderr, "%s called (vector=0x%02x)\n", __FUNCTION__, vector);

	if (env->hflags & HF_WAITING_FOR_STARTUP_MASK) {
		/* Leave WAITING_FOR_STARTUP state. */
		env->hflags &= ~HF_WAITING_FOR_STARTUP_MASK;

		/* Load code segment register. */
		cpu_x86_load_seg_cache(R_CS,
				(uint16_t) vector << 8,	/* Selector */
				(uint32_t) vector << 12,/* Base */
				0xffff,			/* Limit */
				0);			/* Flags */

		/* Load instruction pointer. */
		env->eip = 0x00000000;
	}
}

static void
NAME_(core_power_set)(unsigned int val)
{
	env->state_power = val;
	NAME_(interrupt)();
}

static void
NAME_(core_n_reset_set)(unsigned int n_val)
{
	if (n_val) {
		/* Reset gone. */
		env->state_n_reset |= 1;
	} else {
		/* New reset. */
		env->state_n_reset = 0;
		NAME_(interrupt)();
	}
}

#if 80386 <= CONFIG_CPU
static void
NAME_(core_n_init_set)(unsigned int n_val)
{
	if (n_val) {
		/* Init gone. */
		env->state_n_init |= 1;
	} else {
		/* New init. */
		env->state_n_init = 0;
		NAME_(interrupt)();
	}
}
#endif /* 80386 <= CONFIG_CPU */

static void
NAME_(core_n_ignne_set)(unsigned int n_val)
{
	env->state_n_ignne = n_val;
}
