/*
 * $Id: cmos.c,v 1.12 2009-02-27 08:33:39 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INIT_RM

#include "compiler.h"
CODE16;

#include "cmos.h"
#include "io.h"

#define PCI_ADDR(bus, dev, func)  (((uint32_t) (bus) << 16 ) \
				| ((uint32_t) (dev) << 11) \
				| ((uint32_t) (func) << 8))
#define PCICONF_ADDR    0x0cf8
#define PCICONF_DATA    0x0cfc

void
cmos_init(void)
{
	assert(sizeof(struct cmos) == 128);

#ifdef CONFIG_PCI_SUPPORT
	/*
	 * Enable standard and extended RTC RAM.
	 * Done via Southbridge (PCI bus 0, device 7) config space
	 * register 0xcb.
	 * See description Intel 82371AB, page 67.
	 */
	outl(PCI_ADDR(0, 7, 0) | 0x80000000 | (0xcb & ~3), PCICONF_ADDR);
	outb(0x25, PCICONF_DATA | (0xcb & 3));
#endif
}

void
cmos_exit(void)
{
	uint16_t sum;
	unsigned int reg;

	sum = 0;
	for (reg = 0x10; reg < 0x2e; reg++) {
		sum += cmos_readb(reg);
	}
	cmos_writeb(0x2e, (sum >> 8) & 0xff);
	cmos_writeb(0x2f, (sum >> 0) & 0xff);

	sum = 0;
	for (reg = 0x40; reg < 0x7d; reg++) {
		sum += cmos_readb(reg);
	}
	cmos_writeb(0x7d, (sum >> 8) & 0xff);
	cmos_writeb(0x7e, (sum >> 0) & 0xff);
}

#endif /* INIT_RM */
