/* $Id: conn_vga.c,v 1.2 2009-01-28 12:59:19 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_vga.h"

#define COMP	"conn_vga"

struct cpssp {
	struct sig_video_merge *forward_video;
	struct sig_i2c_bus_merge *forward_i2c_bus;
};

void
conn_vga_init(
	unsigned int nr,
	struct sig_vga *port_port_vga,
	struct sig_vga *port_vga
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_video = sig_video_merge(
			port_port_vga->video, port_vga->video);
	cpssp->forward_i2c_bus = sig_i2c_bus_merge(
			port_port_vga->ddc, port_vga->ddc);
}

unsigned int
conn_vga_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_vga_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
