/*
 * $Id: cpu_jit.h,v 1.56 2009-01-22 16:30:17 potyra Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *
 * Copyright (c) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef __CPU_JIT_H_INCLUDED
#define __CPU_JIT_H_INCLUDED

/*
 * Inline functions
 */
static inline unsigned int
tb_jmp_cache_hash_func(target_ulong pc)
{
	return (pc ^ (pc >> TB_JMP_CACHE_BITS)) & (TB_JMP_CACHE_SIZE - 1);
}

/*
 * Functions
 */
/* cpu_jit_buffer.c */
extern TranslationBlock *
NAME_(tb_get)(target_ulong pc, target_ulong cs_base,
		unsigned int flags, unsigned long t0);
extern void
NAME_(tb_invalidate_phys_page_fast)(target_ulong start, int len);
extern TranslationBlock *
NAME_(tb_find_alloc)(target_ulong pd);
extern TranslationBlock *
NAME_(tb_find_pc)(unsigned long pc_ptr);
extern void
NAME_(interrupt)(void);

extern void
NAME_(jit_buffer_reset)(void);
extern void
NAME_(jit_buffer_init)(struct cpu *css);

/* cpu_jit_compile.c */
extern int
NAME_(gen_code)(struct TranslationBlock *tb, int *gen_code_size_ptr);
extern int
NAME_(restore_state)(struct TranslationBlock *tb, unsigned long searched_pc);

extern void
NAME_(jit_compile_reset)(void);
extern void
NAME_(jit_compile_init)(struct cpu *css);

/* cpu_jit_compile_fast.c */
extern void
NAME_(resume_from_signal)(void *puc);

#endif /* __CPU_JIT_H_INCLUDED */
