/*
 * $Id: system.h,v 1.47 2009-01-28 12:13:01 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SYSTEM_H_INCLUDED
#define __SYSTEM_H_INCLUDED

extern int
system_node_create(const char *name);
extern int
system_node_destroy(unsigned int node_id);

extern int
system_page_create(const char *name);
extern int
system_page_destroy(unsigned int page_id);

extern int
system_sig_create(const char *type, const char *name);
extern void *
system_sig_get(unsigned int sig_id);
extern int
system_sig_unget(void *ptr);
extern int
system_sig_destroy(unsigned int sig);

/** create a component.
 *  @param type component type.
 *  @param name path name of the component.
 *  @param node desired node id of the component.
 *  @param page desired page id of the component.
 *  @return component id or -1 on error.
 */
extern int
system_comp_create(
	const char *type,
	const char *name,
	unsigned int node,
	unsigned int page
);
extern int
system_comp_generic_set(unsigned int comp, const char *generic, const char *value);
extern int
system_comp_port_connect(unsigned int comp, const char *port, unsigned int sig);
extern int
system_comp_init(unsigned int comp);
extern int
system_comp_exit(unsigned int comp);
extern int
system_comp_destroy(unsigned int comp);

extern void
system_comp_connect(unsigned int comp, const char *port, unsigned int sig);
extern void
system_comp_disconnect(unsigned int comp, const char *port);

/** lookup a component by path name
 *  @param name path name of component (same as name of system_comp_create)
 *  @return component id, or -1 if not found.
 */
extern int
system_comp_lookup(const char *name);


/* FIXME */
extern unsigned char floppydrive[4];

#endif /* __SYSTEM_H_INCLUDED */
