/* $Id: difftrace.c,v 1.2 2009-01-28 17:20:10 potyra Exp $ 
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
#include <assert.h>
#include <stdio.h>

#define MAXN	100*1000*1000
static unsigned long addr_q[MAXN];
static unsigned long naddr_qs;
static unsigned long addr_f[MAXN];
static unsigned long naddr_fs;

#define CMAXN	100*1000*1000
static unsigned long caddr_f[CMAXN];
static unsigned long ncaddr_fs = 0;

static void
addnum(unsigned long num)
{
	int l;
	int m;
	int u;
	int n;
	int done;

	/*
	 * Search within first sorted part of array.
	 */
	l = 0;
	u = (ncaddr_fs & ~0xfff) - 1;
	while (l <= u) {
		m = (u + l) / 2;

		assert(0 <= l && l < ncaddr_fs);
		assert(0 <= u && u < ncaddr_fs);
		assert(0 <= m && m < ncaddr_fs);
		assert(l <= m && m <= u);

		if (caddr_f[m] < num) {
			l = m + 1;
		} else if (num < caddr_f[m]) {
			u = m - 1;
		} else {
			/* Found. */
			return;
		}
	}

	/*
	 * Search within unsorted part of array.
	 */
	for (n = ncaddr_fs & ~0xfff; ; n++) {
		if (n == ncaddr_fs) {
			/* Not found. */
			break;
		}
		if (caddr_f[n] == num) {
			/* Found. */
			return;
		}
	}

	/*
	 * Add to unsorted part of array.
	 */
	caddr_f[ncaddr_fs] = num;
	ncaddr_fs++;

	if ((ncaddr_fs & 0xfff) != 0) {
		return;
	}

	/*
	 * Sort whole array.
	 */
	done = 0;
	while (! done) {
		done = 1;

		for (n = 0; n < ncaddr_fs - 1; n++) {
			unsigned long tmp;

			if (caddr_f[n] < caddr_f[n + 1]) {
				continue;
			}

			tmp = caddr_f[n];
			caddr_f[n] = caddr_f[n + 1];
			caddr_f[n + 1] = tmp;

			done = 0;
		}
	}
}

static int
checknum(unsigned long num)
{
	int l;
	int m;
	int u;
	int n;

	/*
	 * Search within first sorted part of array.
	 */
	l = 0;
	u = (ncaddr_fs & ~0xfff) - 1;
	while (l <= u) {
		m = (u + l) / 2;

		assert(0 <= l && l < ncaddr_fs);
		assert(0 <= u && u < ncaddr_fs);
		assert(0 <= m && m < ncaddr_fs);
		assert(l <= m && m <= u);

		if (caddr_f[m] < num) {
			l = m + 1;
		} else if (num < caddr_f[m]) {
			u = m - 1;
		} else {
			/* Found. */
			return 1;
		}
	}

	/*
	 * Search within unsorted part of array.
	 */
	for (n = (ncaddr_fs & ~0xfff) + 1; ; n++) {
		if (n == ncaddr_fs) {
			/* Not found. */
			break;
		}
		if (caddr_f[n] == num) {
			/* Found. */
			return 1;
		}
	}

	return 0;
}

static unsigned long
readnum(FILE *fp)
{
	int c;
	unsigned int x;
	unsigned long num;


	num = 0;
	for (x = 0; x < 8; x++) {
		c = fgetc(fp);
		if (c == EOF) {
			return 0;
		}
		num *= 16;
		if ('0' <= c && c <= '9') {
			num += c - '0';
		} else if ('A' <= c && c <= 'F') {
			num += c - 'A' + 10;
		} else if ('a' <= c && c <= 'f') {
			num += c - 'a' + 10;
		}
	}
	c = fgetc(fp);
	assert(c == '\n');

	return num;
}

static void
readfile(FILE *fp, unsigned long *a, unsigned long *nas)
{
	unsigned long num;

	(*nas) = 0;
	for (;;) {
		num = readnum(fp);
		if (num == 0xfffffff0) {
			continue;
		}
		if (num == 0) {
			break;
		}
		if (*nas == 0 || a[*nas - 1] != num) {
			assert(*nas < MAXN);
			a[(*nas)++] = num;
		}
	}

}

static void
equal(FILE *q, FILE *f)
{
	unsigned int n;
	unsigned long pq;
	unsigned long pf;

	/*
	 * Read all addresses.
	 */
	readfile(q, addr_q, &naddr_qs);
	readfile(f, addr_f, &naddr_fs);

	/*
	 * Read and check addresses.
	 */
	pq = 0;
	pf = 0;
	while (pq < naddr_qs && pf < naddr_fs) {
		static int procent = -1;
		unsigned long nq;
		unsigned long nf;

		if (procent < (pq + pf) * 100 / (naddr_qs + naddr_fs)) {
			procent = (pq + pf) * 100 / (naddr_qs + naddr_fs);
			fprintf(stderr, "%d\n", procent);
		}

		nq = 0;
		for (nf = 0; nf < 100; nf++) {
			if (addr_q[pq + nq] == addr_f[pf + nf]) {
				goto found;
			}
		}
		for (n = 0; n < 1000000; n++) {
			for (nq = 0; nq <= n; nq++) {
				nf = n - nq;
				assert(0 <= nq);
				assert(0 <= nf);
				assert(nq + nf == n);

				if (naddr_qs <= pq + nq) {
					continue;
				}
				if (naddr_fs <= pf + nf) {
					continue;
				}
				if (addr_q[pq + nq] == addr_f[pf + nf]) {
					goto found;
				}
			}
		}
		/* No more matches. */
		break;

	found:	;
		for (n = 0; n < nf; n++) {
			addnum(addr_f[pf]);
			printf("%8s %08lx\n", "", addr_f[pf]);
			pf++;
		}
		for (n = 0; n < nq; n++) {
			printf("%08lx %8s", addr_q[pq], "");
			if (! checknum(addr_q[pq])) {
				/* Not in cache! */
				printf("!");
			}
			printf("\n");
			pq++;
		}
		addnum(addr_f[pf]);
		printf("%08lx %08lx\n", addr_q[pq], addr_f[pf]);
		pq++;
		pf++;
	}
	while (pf < naddr_fs) {
		printf("%8s %08lx!\n", "", addr_f[pf]);
		addnum(addr_f[pf]);
		pf++;
	}
	while (pq < naddr_qs) {
		printf("%08lx %8s", addr_q[pq], "");
		if (! checknum(addr_q[pq])) {
			/* Not in cache! */
			printf("!");
		}
		printf("\n");
		pq++;
	}
}

int
main(int argc, char **argv)
{
	FILE *q;
	FILE *f;

	q = fopen(argv[1], "r");
	assert(q);
	f = fopen(argv[2], "r");
	assert(f);

	equal(q, f);

	fclose(f);
	fclose(q);

	return 0;
}
