/*
 * $Id: glue-gui-null-monitor.c,v 1.1 2009-03-07 09:17:19 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>

#include "glue-main.h"
#include "glue-png.h"

#include "glue-gui-null-monitor.h"

struct cpssp {
	unsigned int monitor_width;
	unsigned int monitor_height;
	unsigned int true_width;
	unsigned int true_height;

	uint8_t *screen_data;
};

void *
gui_null_monitor_create
(
	unsigned int monitor_width,
	unsigned int monitor_height
)
{
	struct cpssp *cpssp;
	unsigned int i;
	uint8_t *val;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->monitor_width = monitor_width;
	cpssp->monitor_height = monitor_height;

	cpssp->true_width = monitor_width;
	cpssp->true_height = monitor_height;

	/* black and completely opaque */
	cpssp->screen_data = malloc(monitor_width * monitor_height * 4);
	assert(cpssp->screen_data);
	val = cpssp->screen_data;
	for (i = 0; i < monitor_width * monitor_height; i++) {
		*val++ = 0;
		*val++ = 0;
		*val++ = 0;
		*val++ = 0xff;
	}

	return cpssp;
}

void
gui_null_monitor_destroy(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *)_cpssp;

	assert(cpssp);
	assert(cpssp->screen_data);

	free(cpssp->screen_data);
	free(cpssp);
}

void
gui_null_monitor_screenshot(void *_cpssp, int nr)
{
	struct cpssp *cpssp = (struct cpssp *)_cpssp;
	char path[PATH_MAX];
	int ret;

	if (nr < 0) {
		/* don't overwrite screenshot, search for free entry */
		static int auto_nr = 0;

		nr = auto_nr; /* So we can recognize if we're looping because
				 there are no more free filenames */
		do {
			auto_nr = (auto_nr + 1) % 1000;
			ret = snprintf(path, sizeof(path), 
				"%s/screenshot-%03d.png", basedir, auto_nr);
			assert(ret < sizeof(path));

			if (access(path, F_OK) != 0) {
				break;
			}
		} while (nr != auto_nr);
		nr = auto_nr;
	}

	ret = snprintf(path, sizeof(path), 
			"%s/screenshot-%03d.png", basedir, nr);
	assert(ret < sizeof(path));

	png_write(
		(uint32_t *) cpssp->screen_data,
		cpssp->monitor_width, cpssp->monitor_height,
		0, 0, cpssp->true_width, cpssp->true_height,
		path);
}

void
gui_null_monitor_pixel_set(
	void *_cpssp,
	unsigned int x,
	unsigned int y,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct cpssp *cpssp = (struct cpssp *)_cpssp;
	unsigned int index;

	if (cpssp->monitor_width <= x
			|| cpssp->monitor_height <= y) return;

	index = (y * cpssp->monitor_width + x) * 4;

	cpssp->screen_data[index + 0] = r;
	cpssp->screen_data[index + 1] = g;
	cpssp->screen_data[index + 2] = b;
}

void
gui_null_monitor_size_set
(
	void *_cpssp,
	unsigned int width,
	unsigned int height
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (cpssp->monitor_width < width 
			|| cpssp->monitor_height < height) return;

	cpssp->true_width = width;
	cpssp->true_height = height;
}
