/* $Id: sig_fault.h,v 1.4 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_FAULT_H_INCLUDED
#define __SIG_FAULT_H_INCLUDED

struct sig_fault_funcs {
	void (*set)(void *s,
		unsigned long long loc0,
		unsigned long long loc1,
		unsigned int val);
};

struct sig_fault {
	struct {
		void *s;
		const struct sig_fault_funcs *f;
	} member[32];
	unsigned int member_count;
};

extern void
sig_fault_set(struct sig_fault *b, void *s,
		unsigned long long loc0, unsigned long long loc1,
		unsigned int val);

extern void
sig_fault_connect(struct sig_fault *b,
		void *s, const struct sig_fault_funcs *f);

extern struct sig_fault *
sig_fault_init(const char *name, unsigned int nr);

extern void
sig_fault_create(const char *name, unsigned int nr);
extern void
sig_fault_destroy(const char *name, unsigned int nr);

#endif /* ! __SIG_FAULT_H_INCLUDED */
