/*
 * $Id: sig_sound.h,v 1.31 2009-03-06 08:23:31 sand Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
#ifndef __SIG_SOUND_H_INCLUDED
#define __SIG_SOUND_H_INCLUDED 

#include <inttypes.h>

#include "glue-audio_format.h"
#include "sig_gen.h"

/*------------------------ DEBUG ---------------------*/
#define DEBUG_SIG_SOUND 0

#ifndef DEBUGPRINT
#define DEBUGPRINT(class, arg...) \
	if (class) fprintf(stderr, "%20s:% 4d: ", __FUNCTION__, __LINE__); \
	if (class) fprintf(stderr, arg); 
#endif
/*------------------------------------------------------*/

#define SIG_SOUND_PROCESS_FREQ	100
#define SIG_SOUND_RATE		44100
#define SIG_SOUND_CHANNELS	2
#define SIG_SOUND_FORMAT	AFMT_S16_NE
/* Bytes per second needed by this sound format */
#define SIG_SOUND_BYTES_PER_SEC (SIG_SOUND_RATE * SIG_SOUND_CHANNELS \
				* sizeof_format(SIG_SOUND_FORMAT)) 
#define SIG_SOUND_MTU	SIG_SOUND_BYTES_PER_SEC / SIG_SOUND_PROCESS_FREQ

struct sig_sound_funcs {
	void (*samples_set)(void *s, int16_t *buf);
};

struct sig_sound {
	enum sig_gen_type type;
	int attr_mode;

	unsigned long long time;

	unsigned int on;
	unsigned long long period;

	unsigned long long phase;

	int16_t sample[SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ * SIG_SOUND_CHANNELS];
	unsigned int nsamples;

	struct {
		void *s;
		const struct sig_sound_funcs *f;
	} member[2];
	int nmembers;
};

extern void
sig_sound_attr_set(struct sig_sound *b, void *s,
		unsigned int on, unsigned long long period);
extern void
sig_sound_samples_set(struct sig_sound *b, void *s,
	int16_t *samples);

extern void
sig_sound_connect(
	struct sig_sound *b,
	void *s,
	const struct sig_sound_funcs *f
);

extern struct sig_sound *
sig_sound_init(const char *name, int nr);

extern void
sig_sound_create(const char *name, int nr);
extern void
sig_sound_destroy(const char *name, int nr);

#endif /* __SIG_SOUND_H_INCLUDED */
