/*
 * $Id: chassis_at_gui.c,v 1.5 2009-03-14 06:29:01 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "chassis_at_gui.h"

#ifdef HAVE_GTK
#include "chassis_at_gui_gtk.h"
#endif

void
chassis_at_gui_init(
	unsigned int nr,
	struct sig_boolean *port_mech_reset_button,
	struct sig_std_logic *port_n_reset_button,
	struct sig_boolean *port_power_led,
	struct sig_boolean *port_opt_power_led,
	struct sig_sound *port_speaker,
	struct sig_sound *port_audio_speaker
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chassis_at_gui_gtk_init(
				nr,
				port_mech_reset_button,
				port_n_reset_button,
				port_power_led,
				port_opt_power_led,
				port_speaker,
				port_audio_speaker
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
chassis_at_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chassis_at_gui_gtk_create(page, nr, name);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
chassis_at_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chassis_at_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
