/*
 * $Id: elevator_rc_gui_gtk.c,v 1.10 2009-03-06 09:55:10 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "umutil.h"

#include "elevator_rc_gui_gtk.h"

#define COMP "elevator_rc"

struct cpssp {
	const char *comp_name;
	unsigned int comp_index;

	struct sig_dio48 *port_dio48;

	struct elevator_rc_button {
		struct cpssp * parent;
		struct sig_std_logic * sig;
	} buttons[21];

	GtkFixed *rc_fixed;

	struct elevator_rc_led {
		GtkWidget *led;
		GdkPixbuf *on;
		GdkPixbuf *off;
	} leds[7];

	struct elevator_rc_simple_led {
		GtkWidget *led;
	} simple_leds[6];

	GtkWidget *floor_sensor_2;
	GtkWidget *floor_sensor_1;
	GtkWidget *floor_sensor_0;

	GtkWidget *door_sensor_2;
	GtkWidget *door_sensor_1;
	GtkWidget *door_sensor_0;
};

static struct cpssp *iface[100];

/* signal callbacks */

static void
elevator_rc_led_set(void *_cpssp, unsigned int val)
{
	struct elevator_rc_led * cpssp = (struct elevator_rc_led *) _cpssp;

	if (val == SIG_STD_LOGIC_1) {
		gtk_image_set_from_pixbuf(GTK_IMAGE(cpssp->led), cpssp->on);
	} else {
		gtk_image_set_from_pixbuf(GTK_IMAGE(cpssp->led), cpssp->off);
	}
	gui_gtk_flush();
}

static void
elevator_rc_simple_led_set(void *_cpssp, unsigned int val)
{
	struct elevator_rc_simple_led * cpssp = (struct elevator_rc_simple_led *) _cpssp;

	if (val == SIG_STD_LOGIC_1) {
		gtk_image_set_from_icon_name(GTK_IMAGE(cpssp->led), "gtk-yes", GTK_ICON_SIZE_BUTTON);
	} else {
		gtk_image_set_from_icon_name(GTK_IMAGE(cpssp->led), "gtk-no", GTK_ICON_SIZE_BUTTON);
	}
	gui_gtk_flush();
}
/* gtk-callbacks */

static void
elevator_rc_button_toggled_event(GtkToggleButton *button, gpointer user_data)
{
	struct elevator_rc_button *cpssp = (struct elevator_rc_button *) user_data;

	if (gtk_toggle_button_get_active(button)) {
		sig_std_logic_set(cpssp->sig, cpssp->parent, SIG_STD_LOGIC_1);
	} else {
		sig_std_logic_set(cpssp->sig, cpssp->parent, SIG_STD_LOGIC_0);
	}
}

/* interface */

void
elevator_rc_gui_gtk_init(
	unsigned int nr,
	struct sig_dio48 *port_dio48
)
{
	int i;
	static struct sig_std_logic_funcs led_funcs = {
		.set = elevator_rc_led_set
	};
	static struct sig_std_logic_funcs simple_led_funcs = {
		.set = elevator_rc_simple_led_set
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	cpssp->port_dio48 = port_dio48;

	for (i = 0; i < 21; i++) {
		cpssp->buttons[i].parent = cpssp;
		cpssp->buttons[i].sig = port_dio48->sig[i];
		sig_std_logic_connect_out(port_dio48->sig[i], cpssp, SIG_STD_LOGIC_0);
	}
	for (i = 0; i < 7; i++) {
		sig_std_logic_connect_in(port_dio48->sig[24 + i], &cpssp->leds[i], &led_funcs);
	}
	for (i = 0; i < 6; i++) {
		sig_std_logic_connect_in(port_dio48->sig[31 + i], &cpssp->simple_leds[i], &simple_led_funcs);
	}
}

void
elevator_rc_gui_gtk_create(
	unsigned int page,
	unsigned int nr,
	const char *name
)
{
	GtkWidget *widget;
	GtkWidget *image;
	GtkWidget *label;
	const char *path;
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->comp_name = name;
	cpssp->comp_index = nr;

	cpssp->rc_fixed = GTK_FIXED(gtk_fixed_new());

	/* generate and place separators */
	widget = gtk_hseparator_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 30, 60);
	gtk_widget_set_size_request(widget, 100, 8);

	widget = gtk_hseparator_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 30, 118);
	gtk_widget_set_size_request(widget, 100, 8);

	/* led 0 */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 80, 130);
	gtk_widget_set_size_request(widget, 40, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_stockwerk_e_aus.png");
	cpssp->leds[0].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_stockwerk_e_an.png");
	cpssp->leds[0].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[0].led = gtk_image_new_from_pixbuf(cpssp->leds[0].off);
	gtk_widget_show(cpssp->leds[0].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[0].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[9]);

	/* led 1 */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 80, 72);
	gtk_widget_set_size_request(widget, 40, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_stockwerk_1_aus.png");
	cpssp->leds[1].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_stockwerk_1_an.png");
	cpssp->leds[1].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[1].led = gtk_image_new_from_pixbuf(cpssp->leds[1].off);
	gtk_widget_show(cpssp->leds[1].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[1].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[10]);

	/* led 2 */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 80, 16);
	gtk_widget_set_size_request(widget, 40, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_stockwerk_2_aus.png");
	cpssp->leds[2].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_stockwerk_2_an.png");
	cpssp->leds[2].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[2].led = gtk_image_new_from_pixbuf(cpssp->leds[2].off);
	gtk_widget_show(cpssp->leds[2].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[2].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[11]);

	/* led 0 up */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 40, 138);
	gtk_widget_set_size_request(widget, 20, 20);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_button_rauf_aus.png");
	cpssp->leds[3].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_button_rauf_an.png");
	cpssp->leds[3].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[3].led = gtk_image_new_from_pixbuf(cpssp->leds[3].off);
	gtk_widget_show(cpssp->leds[3].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[3].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[12]);

	/* led 1 down */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 40, 94);
	gtk_widget_set_size_request(widget, 20, 20);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_button_runter_aus.png");
	cpssp->leds[4].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_button_runter_an.png");
	cpssp->leds[4].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[4].led = gtk_image_new_from_pixbuf(cpssp->leds[4].off);
	gtk_widget_show(cpssp->leds[4].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[4].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[13]);

	/* led 1 up */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 40, 72);
	gtk_widget_set_size_request(widget, 20, 20);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_button_rauf_aus.png");
	cpssp->leds[5].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_button_rauf_an.png");
	cpssp->leds[5].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[5].led = gtk_image_new_from_pixbuf(cpssp->leds[5].off);
	gtk_widget_show(cpssp->leds[5].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[5].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[14]);

	/* led 2 down */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 40, 26);
	gtk_widget_set_size_request(widget, 20, 20);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_button_runter_aus.png");
	cpssp->leds[6].off = gdk_pixbuf_new_from_file(path, NULL);
	path = buildpath(PNGDIR, "aufzug_button_runter_an.png");
	cpssp->leds[6].on = gdk_pixbuf_new_from_file(path, NULL);
	cpssp->leds[6].led = gtk_image_new_from_pixbuf(cpssp->leds[4].off);
	gtk_widget_show(cpssp->leds[6].led);
	gtk_container_add(GTK_CONTAINER(widget), cpssp->leds[6].led);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[15]);

	/* led arrow down */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 140, 100);
	gtk_widget_set_size_request(widget, 44, 44);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_runter_aus_klein.png");
	image = gtk_image_new_from_file(path);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[7]);

	/* led arrow up */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 140, 42);
	gtk_widget_set_size_request(widget, 44, 44);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "aufzug_rauf_aus_klein.png");
	image = gtk_image_new_from_file(path);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[8]);

	/* toggle digit a */
	widget = gtk_toggle_button_new_with_mnemonic("a");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 226, 16);
	gtk_widget_set_size_request(widget, 40, 24);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[0]);

	/* toggle digit b */
	widget = gtk_toggle_button_new_with_mnemonic("b");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 260, 42);
	gtk_widget_set_size_request(widget, 24, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[1]);

	/* toggle digit c */
	widget = gtk_toggle_button_new_with_mnemonic("c");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 260, 110);
	gtk_widget_set_size_request(widget, 24, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[2]);

	/* toggle digit d */
	widget = gtk_toggle_button_new_with_mnemonic("d");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 226, 152);
	gtk_widget_set_size_request(widget, 40, 24);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[3]);

	/* toggle digit e */
	widget = gtk_toggle_button_new_with_mnemonic("e");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 208, 110);
	gtk_widget_set_size_request(widget, 24, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[4]);

	/* toggle digit f */
	widget = gtk_toggle_button_new_with_mnemonic("f");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 208, 42);
	gtk_widget_set_size_request(widget, 24, 40);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[5]);

	/* toggle digit g */
	widget = gtk_toggle_button_new_with_mnemonic("g");
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 226, 84);
	gtk_widget_set_size_request(widget, 40, 24);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click (GTK_BUTTON (widget), FALSE);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[6]);

	/* label Motor */
	label = gtk_label_new("Motor");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 0, 184);
	gtk_widget_set_size_request(label, 60, 16);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

	/* toggle motor */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 16, 202);
	gtk_widget_set_size_request(widget, 28, 28);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	image = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[16]);

	/* label Direction */
	label = gtk_label_new("Direction");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 0, 234);
	gtk_widget_set_size_request(label, 60, 16);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

	/* moving direction */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 16, 252);
	gtk_widget_set_size_request(widget, 28, 28);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	image = gtk_image_new_from_stock ("gtk-go-up", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[17]);

	/* label 2 */
	label = gtk_label_new("2");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 148, 210);
	gtk_widget_set_size_request(label, 20, 20);

	/* label 1 */
	label = gtk_label_new("1");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 148, 234);
	gtk_widget_set_size_request(label, 20, 20);

	/* label 0 */
	label = gtk_label_new("0");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 148, 260);
	gtk_widget_set_size_request(label, 20, 20);

	/* label Door open/close*/
	label = gtk_label_new("Door\nopen/close");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 82, 176);
	gtk_widget_set_size_request(label, 70, 32);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

	/* open/close door 2 */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 104, 206);
	gtk_widget_set_size_request(widget, 24, 24);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "button_tuer_oeffnen.png");
	image = gtk_image_new_from_file(path);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[20]);

	/* open/close door 1 */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 104, 232);
	gtk_widget_set_size_request(widget, 24, 24);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "button_tuer_oeffnen.png");
	image = gtk_image_new_from_file(path);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[19]);

	/* open/close door 0 */
	widget = gtk_toggle_button_new();
	gtk_widget_show(widget);
	gtk_fixed_put(cpssp->rc_fixed, widget, 104, 258);
	gtk_widget_set_size_request(widget, 24, 24);
	gtk_widget_set_sensitive(widget, TRUE);
	gtk_button_set_focus_on_click(GTK_BUTTON(widget), FALSE);
	path = buildpath(PNGDIR, "button_tuer_oeffnen.png");
	image = gtk_image_new_from_file(path);
	gtk_widget_show(image);
	gtk_container_add(GTK_CONTAINER(widget), image);
	g_signal_connect(widget, "toggled", G_CALLBACK(elevator_rc_button_toggled_event), &cpssp->buttons[18]);

	/* label Floor Sensors */
	label = gtk_label_new("Floor\nSensors");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 154, 176);
	gtk_widget_set_size_request(label, 70, 32);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

	/* floor sensor 2 */
	cpssp->simple_leds[2].led = gtk_image_new_from_icon_name("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(cpssp->simple_leds[2].led);
	gtk_fixed_put(cpssp->rc_fixed, cpssp->simple_leds[2].led, 182, 210);
	gtk_widget_set_size_request(cpssp->simple_leds[2].led, 18, 18);
	gtk_widget_set_sensitive(cpssp->simple_leds[2].led, TRUE);

	/* floor sensor 1 */
	cpssp->simple_leds[1].led = gtk_image_new_from_icon_name("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(cpssp->simple_leds[1].led);
	gtk_fixed_put(cpssp->rc_fixed, cpssp->simple_leds[1].led, 182, 236);
	gtk_widget_set_size_request(cpssp->simple_leds[1].led, 18, 18);
	gtk_widget_set_sensitive(cpssp->simple_leds[1].led, TRUE);

	/* floor sensor 0 */
	cpssp->simple_leds[0].led = gtk_image_new_from_icon_name("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(cpssp->simple_leds[0].led);
	gtk_fixed_put(cpssp->rc_fixed, cpssp->simple_leds[0].led, 182, 260);
	gtk_widget_set_size_request(cpssp->simple_leds[0].led, 18, 18);
	gtk_widget_set_sensitive(cpssp->simple_leds[0].led, TRUE);

	/* label Door Sensors */
	label = gtk_label_new("Door\nSensors");
	gtk_widget_show(label);
	gtk_fixed_put(cpssp->rc_fixed, label, 224, 176);
	gtk_widget_set_size_request(label, 70, 32);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

	/* door sensor 2 */
	cpssp->simple_leds[5].led = gtk_image_new_from_icon_name("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(cpssp->simple_leds[5].led);
	gtk_fixed_put(cpssp->rc_fixed, cpssp->simple_leds[5].led, 252, 210);
	gtk_widget_set_size_request(cpssp->simple_leds[5].led, 18, 18);
	gtk_widget_set_sensitive(cpssp->simple_leds[5].led, TRUE);

	/* door sensor 1 */
	cpssp->simple_leds[4].led = gtk_image_new_from_icon_name("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(cpssp->simple_leds[4].led);
	gtk_fixed_put(cpssp->rc_fixed, cpssp->simple_leds[4].led, 252, 236);
	gtk_widget_set_size_request(cpssp->simple_leds[4].led, 18, 18);
	gtk_widget_set_sensitive(cpssp->simple_leds[4].led, TRUE);

	/* door sensor 0 */
	cpssp->simple_leds[3].led = gtk_image_new_from_icon_name("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(cpssp->simple_leds[3].led);
	gtk_fixed_put(cpssp->rc_fixed, cpssp->simple_leds[3].led, 252, 260);
	gtk_widget_set_size_request(cpssp->simple_leds[3].led, 18, 18);
	gtk_widget_set_sensitive(cpssp->simple_leds[3].led, TRUE);

	gtk_widget_show_all(GTK_WIDGET(cpssp->rc_fixed));

	gui_gtk_comp_add(page, COMP, nr, name,
			GTK_WIDGET(cpssp->rc_fixed), TRUE, TRUE, NULL);

	iface[nr] = cpssp;
}

void
elevator_rc_gui_gtk_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
