/* $Id: isa_gen_parallel.c,v 1.10 2009-01-28 12:59:20 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include "fixme.h"
#include <stdio.h>

#include "glue-shm.h"

#include "isa_gen_parallel.h"

#define COMP "isa_gen_parallel"

struct cpssp {
	/* Config */

	/* Ports */

	/* Signals */

	/* State */

	/* Processes */

	int dummy;
};

void
isa_gen_parallel_init(
	unsigned int nr,
	struct sig_isa_bus *port_isa,
	struct sig_parallel *port_par
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	/* FILL ME */
}

void
isa_gen_parallel_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	/* FILL ME */

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
isa_gen_parallel_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	/* FILL ME */

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
