/*
 * $Id: media_gen_cd.c,v 1.7 2009-03-30 07:56:03 vrsieh Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue-shm.h"

#include "media_gen_cd.h"

#define COMP	"media_gen_cd"

struct cpssp {
	char name[1024];
	enum { TYPE_CD_ROM, TYPE_CD_R, TYPE_CD_RW } media;
	unsigned int size;
	const char *iso_image;
	const char *cue_sheet;
};

static int
media_gen_cd_read(void *_cpssp, unsigned long long blk, uint8_t *buf)
{
	return 0;
}

static int
media_gen_cd_write(void *_cpssp, unsigned long long blk, const uint8_t *buf)
{
	return 0;
}

void
media_gen_cd_init(unsigned int nr, struct sig_magneto_optical *port_connect)
{
	static const struct sig_magneto_optical_funcs connect_funcs = {
		.read = media_gen_cd_read,
		.write = media_gen_cd_write,
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	sig_magneto_optical_connect(port_connect, cpssp, &connect_funcs);
}

void
media_gen_cd_create(
	unsigned int nr,
	const char *name,
	const char *media,
	const char *size,
	const char *iso,
	const char *cue
)
{
	struct cpssp *cpssp;

	if (! media) media = "CD-RW";
	if (! size) size = "360000"; /* 80*60*75 */

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	/* name */
	assert(strlen(name) < sizeof(cpssp->name));
	strcpy(cpssp->name, name);

	/* media */
	if (strcmp(media, "CD-ROM") == 0) {
		cpssp->media = TYPE_CD_ROM;
	} else if (strcmp(media, "CD-R") == 0) {
		cpssp->media = TYPE_CD_R;
	} else if (strcmp(media, "CD-RW") == 0) {
		cpssp->media = TYPE_CD_RW;
	} else {
		assert(0); /* FIXME */
	}

	/* size */
	cpssp->size = atoi(size);

	/* contents */
	cpssp->iso_image = iso;
	cpssp->cue_sheet = cue;

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
media_gen_cd_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
