/*
 * $Id: memory_gui.c,v 1.5 2009-03-14 06:29:01 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "memory_gui.h"

#ifdef HAVE_GTK
#include "memory_gui_gtk.h"
#endif

void
memory_gui_init(
	unsigned int nr,
	struct sig_manage *manage,
	struct sig_mem_bus *port_conn,
	struct sig_fault *fault_bitflip,
	struct sig_fault *fault_stuck_at_0,
	struct sig_fault *fault_stuck_at_1,
	struct sig_fault *fault_coupling
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		memory_gui_gtk_init(
				nr,
				manage,
				port_conn,
				fault_bitflip,
				fault_stuck_at_0,
				fault_stuck_at_1,
				fault_coupling
			       );
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
memory_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *size
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		memory_gui_gtk_create(page, nr, name, size);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
memory_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		memory_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
