/* $Id: network_tap.c,v 1.7 2009-01-28 12:59:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* Hack to get ntohl etc working */
#define _LINUX_BYTEORDER_GENERIC_H	1

#include "config.h"

#if defined(HAVE_LINUX_IF_TUN_H) || defined(HAVE_NET_IF_TUN_H)

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#ifdef HAVE_LINUX_IF_TUN_H
#include <linux/if_tun.h>
#endif
#ifdef HAVE_NET_IF_TUN_H
#include <net/if_tun.h>
#endif
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <assert.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "glue-io.h"
#include "glue-main.h"

#include "network_setup.h"
#include "network_system.h"
#include "network_tap.h"


static const char *tuntap_name = NULL;
static int tap_fd;


static int
tuntap_send(const unsigned char *buf, unsigned int bufsize)
{
	int ret;

	ret = write(tap_fd, buf, bufsize);

	return ret;
}

/* FIXME */
extern void
bridge_real_to_virt(unsigned char *buf, unsigned int len);

static void
tuntap_interrupt(int fd, void *_css)
{
	unsigned char buf[2048];
	int len;

	for (;;) {
		do {
			len = read(tap_fd, buf, sizeof(buf));
		} while (len < 0 && errno == EINTR);
		if (len < 0 && errno == EAGAIN) {
			break;
		}
		assert(0 < len);

		bridge_real_to_virt(buf, len);
	}
}

#ifdef HAVE_LINUX_IF_TUN_H
static int
tuntap_open(void)
{
	int ret;
	struct ifreq	ifr;

	/* open tap device */

	tap_fd = open("/dev/tun", O_RDWR);
	if( tap_fd<0 && errno==ENOENT )
		tap_fd = open("/dev/net/tun", O_RDWR);
	if (tap_fd < 0) {
		fprintf(stderr, "can't open /dev/tun or /dev/net/tun: %s\n",
				strerror(errno));
		exit(1);
	}

	memset((void *) &ifr, 0, sizeof(ifr));
	ifr.ifr_flags = IFF_TAP | IFF_NO_PI;
	strcpy(ifr.ifr_name, tuntap_name);
	ret = ioctl(tap_fd, TUNSETIFF, (void *) &ifr);
	if (ret < 0) {
		fprintf(stderr, "can't TUNSETIFF to tap: %s\n",
				strerror(errno));
		exit(1);
	}

	io_register(tap_fd, (void *) 1, tuntap_interrupt);

	fprintf(stderr, "installed interface %s\n", ifr.ifr_name);
	return 0;
}
#endif

#ifdef HAVE_NET_IF_TUN_H
static int
tuntap_open(void)
{
	char tunname[256];

	tunname[sizeof(tunname)-1] = '\0';
	snprintf(tunname, sizeof(tunname)-1, "/dev/%s", tuntap_name);
	tap_fd = open(tunname, O_RDWR);
	if (tap_fd < 0) {
		fprintf(stderr, "%s: %s\n", tunname, strerror(errno));
		exit(1);
	}

	io_register(tap_fd, (void *) 1, tuntap_interrupt);

	return 0;
}
#endif

static int
tuntap_close(void)
{
	int ret;

	if (tap_fd < 0) {
		return 0;
	}

	io_unregister(tap_fd);

	ret = close(tap_fd);

	return ret;
}

const struct real_ops *
tuntap_config(const char *name)
{
	static const struct real_ops tuntap_ops = {
		.send = tuntap_send,
		.init = tuntap_open,
		.exit = tuntap_close,
	};

	assert(strlen(name) <= 12);

	tuntap_name = name;

	return &tuntap_ops;
}

#else /* defined(HAVE_LINUX_IF_TUN_H) || defined(HAVE_NET_IF_TUN_H) */

#include <assert.h>
#include <stdio.h>

#include "network_setup.h"
#include "network_tap.h"

const struct real_ops *
tuntap_config(const char *name)
{
	/* not supported */
	return NULL;
}

#endif /* defined(HAVE_LINUX_IF_TUN_H) || defined(HAVE_NET_IF_TUN_H) */
