/*
 * $Id: pci_intel_eepro100_gui.c,v 1.6 2009-03-14 06:29:01 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "pci_intel_eepro100_gui.h"

#ifdef HAVE_GTK
#include "pci_intel_eepro100_gui_gtk.h"
#endif

void
pci_intel_eepro100_gui_init(
	unsigned int nr,
	struct sig_manage *manage,
	struct sig_pci_bus *port_pci,
	struct sig_eth *port_eth,
	struct sig_boolean *port_opt_busy_led,
	struct sig_fault *fault_recv_loss,
	struct sig_fault *fault_send_loss
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		pci_intel_eepro100_gui_gtk_init(
				nr,
				manage,
				port_pci,
				port_eth,
				port_opt_busy_led,
				fault_recv_loss,
				fault_send_loss
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
pci_intel_eepro100_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *mac
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		pci_intel_eepro100_gui_gtk_create(page, nr, name, mac);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
pci_intel_eepro100_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		pci_intel_eepro100_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
