/* $Id: ps2_gen_mouse_4.c,v 1.7 2009-05-07 09:49:23 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "ps2_gen_mouse_4.h"

#define COMP_(x)	ps2_gen_mouse_4_ ## x
#define COMP		"ps2_gen_mouse_4"

struct cpssp {
	struct sig_ps2_main *port_ps2;

#define NAME		mouse
#define NAME_(x)	mouse_ ## x
#define SNAME		"mouse"

#define MOUSE_TYPE 4
#define STATE
#include "arch_gen_mouse.c"
#undef STATE
};

static void
mouse_send(struct cpssp *cpssp, uint8_t byte)
{
	sig_ps2_send(cpssp->port_ps2, cpssp, byte);
}

#define NAME		mouse
#define NAME_(x)	mouse_ ## x
#define SNAME		"mouse"

#define MOUSE_TYPE 4
#define BEHAVIOUR
#include "arch_gen_mouse.c"
#undef BEHAVIOUR

static void
COMP_(power_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_power_set(cpssp, val);
}

static void
COMP_(recv)(void *_cpssp, uint8_t byte)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_recv(cpssp, byte);
}

static void
COMP_(clkrunning)(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_clkrunning(cpssp, val);
}

static void
COMP_(deltax_set)(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_deltax_set(cpssp, val);
}

static void
COMP_(deltay_set)(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_deltay_set(cpssp, val);
}

static void
COMP_(deltaz_set)(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_deltaz_set(cpssp, val);
}

static void
COMP_(button1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_button1_set(cpssp, val);
}

static void
COMP_(button2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_button2_set(cpssp, val);
}

static void
COMP_(button3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_button3_set(cpssp, val);
}

static void
COMP_(button4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_button4_set(cpssp, val);
}

static void
COMP_(button5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	mouse_button5_set(cpssp, val);
}

void
COMP_(init)(
	unsigned int nr,
	struct sig_ps2 *port_ps2,
	struct sig_integer *port_deltax,
	struct sig_integer *port_deltay,
	struct sig_integer *port_deltaz,
	struct sig_boolean *port_button1,
	struct sig_boolean *port_button2,
	struct sig_boolean *port_button3,
	struct sig_boolean *port_button4,
	struct sig_boolean *port_button5
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = COMP_(power_set),
	};
	static const struct sig_ps2_main_funcs ps2_funcs = {
		.recv = COMP_(recv),
		.clkrunning = COMP_(clkrunning),
	};
	static const struct sig_integer_funcs deltax_funcs = {
		.set = COMP_(deltax_set),
	};
	static const struct sig_integer_funcs deltay_funcs = {
		.set = COMP_(deltay_set),
	};
	static const struct sig_integer_funcs deltaz_funcs = {
		.set = COMP_(deltaz_set),
	};
	static const struct sig_boolean_funcs button1_funcs = {
		.set = COMP_(button1_set),
	};
	static const struct sig_boolean_funcs button2_funcs = {
		.set = COMP_(button2_set),
	};
	static const struct sig_boolean_funcs button3_funcs = {
		.set = COMP_(button3_set),
	};
	static const struct sig_boolean_funcs button4_funcs = {
		.set = COMP_(button4_set),
	};
	static const struct sig_boolean_funcs button5_funcs = {
		.set = COMP_(button5_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	mouse_init(cpssp);

	/* Call */
	cpssp->port_ps2 = port_ps2->main;
	sig_ps2_main_connect(port_ps2->main, cpssp, &ps2_funcs);

	/* Out */

	/* In */
	sig_boolean_connect_in(port_ps2->p5V, cpssp, &power_funcs);

	sig_integer_connect_in(port_deltax, cpssp, &deltax_funcs);
	sig_integer_connect_in(port_deltay, cpssp, &deltay_funcs);
	sig_integer_connect_in(port_deltaz, cpssp, &deltaz_funcs);

	sig_boolean_connect_in(port_button1, cpssp, &button1_funcs);
	sig_boolean_connect_in(port_button2, cpssp, &button2_funcs);
	sig_boolean_connect_in(port_button3, cpssp, &button3_funcs);
	sig_boolean_connect_in(port_button4, cpssp, &button4_funcs);
	sig_boolean_connect_in(port_button5, cpssp, &button5_funcs);
}

void
COMP_(create)(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	mouse_create(cpssp);

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
COMP_(destroy)(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	mouse_destroy(cpssp);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
