/*
 * $Id: scsi_gen_cdrom_gui.c,v 1.7 2009-03-26 14:54:04 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "scsi_gen_cdrom_gui.h"

#ifdef HAVE_GTK
#include "scsi_gen_cdrom_gui_gtk.h"
#endif

void
scsi_gen_cdrom_gui_init(
	unsigned int nr,
	struct sig_power_device *port_power,
	struct sig_scsi_bus *port_scsi,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		scsi_gen_cdrom_gui_gtk_init(nr, port_power, port_scsi,
				port_media, port_change);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
scsi_gen_cdrom_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *scsi_id_str
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		scsi_gen_cdrom_gui_gtk_create(page, nr, name, scsi_id_str);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
scsi_gen_cdrom_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		scsi_gen_cdrom_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
