/*
 * $Id: arch_gen_cpu_x86_fpu_fast.h,v 1.5 2009-10-09 08:00:29 sand Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *
 *  Copyright (c) 2007-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef FAST
#error "Don't include in non-fast modules."
#endif

#ifndef __CPU_FPU_FAST_H_INCLUDED
#define __CPU_FPU_FAST_H_INCLUDED

#include "qemu/exec.h"

#if defined(DARWIN) && defined(__x86_64__)
#if defined(USE_X86LDOUBLE)
extern int32_t
NAME_(helper_float32_to_int32)(float32 x);
extern int64_t
NAME_(helper_float32_to_int64)(float32 x);
extern int32_t
NAME_(helper_float64_to_int32)(float64 x);
extern int64_t
NAME_(helper_float64_to_int64)(float64 x);
extern int32_t
NAME_(helper_floatx_to_int32)(floatx80 x);
extern int64_t
NAME_(helper_floatx_to_int64)(floatx80 x);
#else
extern int32_t
NAME_(helper_floatx_to_int32)(float64 x);
extern int64_t
NAME_(helper_floatx_to_int64)(float64 x);
#endif
#endif
extern void
NAME_(helper_fldt_ST0_A0)(void);
extern void
NAME_(helper_fstt_ST0_A0)(void);
extern void
NAME_(fpu_raise_ferr)(void);
extern void
NAME_(fpu_check_ferr)(void);
extern CPU86_LDouble
NAME_(helper_fdiv)(CPU86_LDouble a, CPU86_LDouble b);
extern void
NAME_(helper_fbld_ST0_A0)(void);
extern void
NAME_(helper_fbst_ST0_A0)(void);
extern void
NAME_(helper_f2xm1)(void);
extern void
NAME_(helper_fyl2x)(void);
extern void
NAME_(helper_fptan)(void);
extern void
NAME_(helper_fpatan)(void);
extern void
NAME_(helper_fxtract)(void);
extern void
NAME_(helper_fprem1)(void);
extern void
NAME_(helper_fprem)(void);
extern void
NAME_(helper_fyl2xp1)(void);
extern void
NAME_(helper_fsqrt)(void);
extern void
NAME_(helper_fsincos)(void);
extern void
NAME_(helper_frndint)(void);
extern void
NAME_(helper_fscale)(void);
extern void
NAME_(helper_fsin)(void);
extern void
NAME_(helper_fcos)(void);
extern void
NAME_(helper_fxam_ST0)(void);
extern void
NAME_(helper_fstenv)(target_ulong ptr, int data32);
extern void
NAME_(helper_fldenv)(target_ulong ptr, int data32);
extern void
NAME_(helper_fsave)(target_ulong ptr, int data32);
extern void
NAME_(helper_frstor)(target_ulong ptr, int data32);
extern void
NAME_(helper_fxsave)(target_ulong ptr, int data64);
extern void
NAME_(helper_fxrstor)(target_ulong ptr, int data64);

extern void
NAME_(get_fp80)(uint64_t *pmant, uint16_t *pexp, CPU86_LDouble f);
extern CPU86_LDouble
NAME_(set_fp80)(uint64_t mant, uint16_t upper);

extern float
NAME_(approx_rsqrt)(float a);
extern float
NAME_(approx_rcp)(float a);
extern void
NAME_(update_fp_status)(void);

#endif /* __CPU_FPU_FAST_H_INCLUDED */
