#!/bin/sh

# $Id: gen_vhdl_faults.sh,v 1.2 2009-11-19 12:46:30 potyra Exp $
# 
# Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

set -e

# timeout type harddisk [block1 block2 block3 block4]

if [ $# -lt 3 ]; then
	echo "Usage $0: timeout type hard_disk [block block ..]"
	echo "type: [golden, block-fault]"
	exit 1
fi


#initial delay (ms) before faults get injected.
INITIAL_DELAY=$1
shift
FAULT_TYPE=$1
shift
FAULTY_DISK=$1
shift

# source file
SOURCE_VHDL=../test-fi-smart-step2/fi.vhdl.in
# target
TARGET_VHDL=fi.vhdl


case $FAULT_TYPE in 
	golden)
		FAULT_ACTIVATE_SNIPPET=""
		echo "Golden run (no faults) selected."
	;;
	block-fault)
		FAULT_ACTIVATE_SNIPPET=""
		
		for i in $*; do
			# add a shortcut for every faulty block
			X1="shortcut_int_out(err,"
			X2="\":pc:${FAULTY_DISK}\", "
			X3="\"block_fault\/${i}\");"
				
			FAULT_ACTIVATE_SNIPPET="${FAULT_ACTIVATE_SNIPPET} \
					       @NEWLINE@${X1}${X2}${X3}"
		done

		# print some information
		echo -n "Block fault for ${FAULTY_DISK} after "
		echo -n "${INITIAL_DELAY} ms on blocks "
		echo "on blocks $* selected."
	;;
	*)
		echo "Invalid argument."
		echo "Usage: $0 DELAY {golden|block-fault} hdd" \
			"[23 42 ..]"
		exit 1
	;;
esac

sed -e"s/@FAULT_INITIAL_DELAY@/${INITIAL_DELAY}/" \
    -e"s/@FAULT_CONNECT@/${FAULT_ACTIVATE_SNIPPET}/" \
    -e"s/@NEWLINE@/\n/g" \
    ${SOURCE_VHDL} > ${TARGET_VHDL}
