/*
 * $Id: memory.c,v 1.4 2009-01-27 17:06:41 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void *
mem_new(size_t s)
{
	void *mem;

	mem = malloc(s);
	assert(mem != NULL);

	return mem;
}

char *
mem_new_string(const char *src)
{
	char *dst;

	dst = mem_new(strlen(src) + 1);
	strcpy(dst, src);

	return dst;
}

void
mem_free(void *ptr)
{
}
