/*
 * $Id: sig_dio48.c,v 1.11 2009-05-21 16:38:07 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_dio48.h"

struct sig_dio48 *
sig_dio48_create(const char *name)
{
	struct sig_dio48 *sig;
	char n[1000];
	unsigned int i;

	sig = malloc(sizeof(*sig));
	assert(sig);

	for (i = 0; i < 48; i++) {
		sprintf(n, "%s-sig%02d", name, i);
		sig->sig[i] = sig_std_logic_create(n);
	}

	return sig;
}

void
sig_dio48_destroy(struct sig_dio48 *sig)
{
	unsigned int i;

	assert(sig);
	/* assert(sig->type == SIG_GEN_DIO48); */

	for (i = 0; i < 48; i++) {
		sig_std_logic_destroy(sig->sig[i]);
	}

	free(sig);
}
