/*
 * $Id: sig_mem_bus.c,v 1.14 2009-05-21 16:38:08 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_mem_bus.h"

struct sig_mem_bus_main *
sig_mem_bus_main_create(const char *name)
{
	return (struct sig_mem_bus_main *) 0;
}

void
sig_mem_bus_main_destroy(struct sig_mem_bus_main *sig)
{
	assert(sig == NULL);
}

struct sig_mem_bus *
sig_mem_bus_create(const char *name)
{
	struct sig_mem_bus *b;
	char n[1000];
	
	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_MEM_BUS;

	sprintf(n, "%s-power", name);
	b->power = sig_boolean_create(n);
	sprintf(n, "%s-cs0", name);
	b->cs0 = sig_cs_create(n);
	sprintf(n, "%s-cs1", name);
	b->cs1 = sig_cs_create(n);
	sprintf(n, "%s-i2cbus", name);
	b->i2cbus = sig_i2c_bus_create(n);
	sprintf(n, "%s-id0", name);
	b->id0 = sig_boolean_create(n);
	sprintf(n, "%s-id1", name);
	b->id1 = sig_boolean_create(n);
	sprintf(n, "%s-id2", name);
	b->id2 = sig_boolean_create(n);

	return b;
}

void
sig_mem_bus_destroy(struct sig_mem_bus *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_MEM_BUS);

	sig_boolean_destroy(sig->power);
	sig_cs_destroy(sig->cs0);
	sig_cs_destroy(sig->cs1);
	sig_i2c_bus_destroy(sig->i2cbus);
	sig_boolean_destroy(sig->id0);
	sig_boolean_destroy(sig->id1);
	sig_boolean_destroy(sig->id2);

	free(sig);
}
