# $Id: experiment.mk,v 1.30 2010-02-22 12:11:02 potyra Exp $
#
# All knowing Makefile to perform experiments.
# 
# Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
#
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

# Usage of this Makefile:
# 
# define at least
#       DVD_IMAGE | CDROM_IMAGE | FLOPPY_IMAGE
#       SIMULATION_PC
# in your Makefile.
# Then include this file
# 
# in case of need, put a local 
# 	test_bench.vhdl
# 	user-begin.vhdl
# 	user-end.vhdl
#	SIMULATION_PC
#
# into your experiment directory which will override the file from
# this directory.

# global definitions:

# installation directory (prefix) of FAUmachine
FAUM_INST_DIR := $(subst bin/,,$(dir $(shell which faum-node-pc)))
# data directory relative to FAUM_INST_DIR
FAUM_DATA_DIR := $(FAUM_INST_DIR)share/faumachine/vhdl/
# fauhdlc VHDL compiler
FAUHDLC := $(shell which fauhdlc)
# FAUmachines faum-gen-vhdl script
FAUM_GEN_VHDL := $(shell which faum-gen-vhdl)
# location of experiment directory.
# (so that make -f /someplace/Makefile experiment works)
EXP_DIR := $(dir $(firstword $(MAKEFILE_LIST)))
ifeq ($(EXP_DIR),)
	EXP_DIR := ./
endif

# variables that must get set:
#
# which pc to take for simulation?
#SIMULATION_PC := pc-1.vhdl
#
# which media image to use? (may be a list of images)
#DVD_IMAGE := Debian-3.0r0-CD-1
#
# Optional additional definitions:
#
# adjust the disk size of the used PC
#CHANGE_DISK_SIZE := 8192
#
# adjust the memory size of the used PC
#CHANGE_MEM_SIZE := 128
#
# one additional VHDL file to be added after user-end.vhdl.
#ADDITIONAL_VHDL := fi.vhdl
#
# additional vhdl files generated from more/custom generate files to be used
# as user input. Use full path for these if not generated in current 
# directory.
#ADDITIONAL_USER_VHDL := 01generate.vhdl
#
# list of VHDL files in local directory that are added to system.vhdl as 
# first portion.
#ADDITIONAL_HW_VHDL := somefile.vhdl otherfile.vhdl
#
# possible extensions:
# override the clean, distclean target with a double-colon rule to 
# clean up more files.
#clean distclean::
#	$(RM) some_other_files
#
#
# add additional prerequisites to system.vhdl with a double-colon
# rule, in case images need to be generated beforehand.
#
#system.vhdl:: project.iso
#project.iso: project.tar.gz
#	tar -xvzf project.tar.gz 
#	cd project; mksiofs -J -R -o ../project.iso
#
# directly add a sed regular expression for pc.vhdl
#PC_SED := -e 's/pci_cirrus_gd5446/pci_cirrus_gd5446_2mb/'

# internal variables, not meant to be overridden
# actual pc file
HW_PC:= \
	$(firstword \
		$(wildcard $(EXP_DIR)/$(SIMULATION_PC) \
			$(FAUM_DATA_DIR)/$(SIMULATION_PC)))
ifeq ($(HW_PC),)
$(error Cannot find VHDL for simulation pc $(SIMULATION_PC))
endif

# use dvds for obsolete MEDIA_IMAGE
ifneq ($(MEDIA_IMAGE),)
$(warning Obsolete MEDIA_IMAGE used, please use DVD_IMAGE instead)
	DVD_IMAGE += $(MEDIA_IMAGE)
endif

# actual media files
ACTUAL_MEDIA := \
	$(DVD_IMAGE) \
	$(CDROM_IMAGE) \
	$(FLOPPY_IMAGE)

# actual user-begin.vhdl file
HW_USER_BEGIN := \
	$(firstword \
		$(wildcard $(EXP_DIR)/user-begin.vhdl \
			$(FAUM_DATA_DIR)/user-begin.vhdl))

# actual user-end.vhdl file
HW_USER_END := \
	$(firstword \
		$(wildcard $(EXP_DIR)/user-end.vhdl \
			$(FAUM_DATA_DIR)/user-end.vhdl))

# actual test-bench.vhdl file
HW_TEST_BENCH := \
	$(firstword \
		$(wildcard $(EXP_DIR)/test_bench.vhdl \
			$(FAUM_DATA_DIR)/test_bench.vhdl))

# determine location of simulation.setup
SIMSETUP := $(firstword \
		$(wildcard \
			simulation.setup \
			$(EXP_DIR)/simulation.setup \
			$(FAUM_DATA_DIR)/simulation.setup))

# sed expression to change disk size
CDS_SED := /disksize : integer := [0-9][0-9]*/disksize : integer :=
# same for memsize
CMS_SED := /memsize : integer := [0-9][0-9]*/memsize : integer :=

# calculate applicable SED expression for pc.vhdl
ifneq ($(CHANGE_MEM_SIZE),)
PC_SED += -e s'$(CMS_SED) $(CHANGE_MEM_SIZE)/'
endif
ifneq ($(CHANGE_DISK_SIZE),)
PC_SED += -e s'$(CDS_SED) $(CHANGE_DISK_SIZE)/'
endif

# search for ADDITIONAL_VHDL in local dir, EXP_DIR, and finally
# in hardware directory.
ifneq ($(ADDITIONAL_VHDL),)
ADDITIONAL_VHDL_FILE := \
	$(firstword \
		$(wildcard $(ADDITIONAL_VHDL) \
			$(EXP_DIR)/$(ADDITIONAL_VHDL) \
			$(FAUM_DATA_DIR)/$(ADDITIONAL_VHDL)))
endif

ifneq ($(ADDITIONAL_HW_VHDL),)
ADDITIONAL_HW_VHDL_FILES := $(addprefix $(EXP_DIR)/,$(ADDITIONAL_HW_VHDL))
endif

# default targets

# all -> do nothing.
all:
	@true

# generate media image
../CDROM.images/%:
	$(MAKE) -C ../CDROM.images $*

# genrate system.vhdl from other vhdl files and from generate file
system.vhdl:: \
		$(HW_PC) \
		$(HW_USER_BEGIN) \
		generate \
		$(HW_USER_END) \
		$(HW_TEST_BENCH) \
		$(FAUM_GEN_VHDL) \
		$(ACTUAL_MEDIA) \
		$(FAUM_DATA_DIR)/experiment.mk \
		$(EXP_DIR)/Makefile \
		$(ADDITIONAL_VHDL_FILE) \
		$(ADDITIONAL_USER_VHDL) \
		$(ADDITIONAL_HW_VHDL_FILES)
	$(RM) system.vhdl
ifneq ($(ADDITIONAL_HW_VHDL_FILES),)
	cat $(ADDITIONAL_HW_VHDL_FILES) >> system.vhdl
endif
ifeq ($(PC_SED),)
	cat $(HW_PC) >> system.vhdl
else
	cat $(HW_PC) | \
		sed $(PC_SED) >> system.vhdl
endif
	cat $(HW_USER_BEGIN) >> system.vhdl
	$(FAUM_GEN_VHDL) generate $(EXP_DIR) >> system.vhdl
ifneq ($(ADDITIONAL_USER_VHDL),)
	cat $(ADDITIONAL_USER_VHDL) >> system.vhdl
endif
	cat $(HW_USER_END) >> system.vhdl
ifneq ($(ADDITIONAL_VHDL_FILE),)
	cat $(ADDITIONAL_VHDL_FILE) >> system.vhdl
endif

ifneq ($(ACTUAL_MEDIA),)
	for i in $(FLOPPY_IMAGE) $(CDROM_IMAGE) $(DVD_IMAGE); do \
		FIXED_IMG=$$(echo "$$i" | sed -e "s/[^a-zA-Z0-9]//g"); \
		if [ ! "$$i" = "$$FIXED_IMG" ]; then \
			ln -s "$$i" "$$FIXED_IMG"; \
		fi; \
	done; \
	IDX="1"; \
	IMGS=\
	$$(for i in $(FLOPPY_IMAGE); do \
		FIXED_IMG=$$(echo "$$i" | sed -e "s/[^a-zA-Z0-9]//g"); \
		printf "$$FIXED_IMG : media_gen_floppy "; \
		printf "generic map \("; \
		printf "image => \\\\\"$$FIXED_IMG\\\\\"";\
		printf "\) "; \
		printf "port map \("; \
		printf "connect => floppy_conn\($$IDX\)"; \
		printf "\); "; \
		IDX=$$(expr $$IDX + 1); \
	done; \
	for i in $(CDROM_IMAGE); do \
		FIXED_IMG=$$(echo "$$i" | sed -e "s/[^a-zA-Z0-9]//g"); \
		printf "$$FIXED_IMG : media_gen_cd "; \
		printf "generic map \("; \
		printf "media => \\\\\"CD-ROM\\\\\", "; \
		printf "iso => \\\\\"$$FIXED_IMG\\\\\"";\
		printf "\) "; \
		printf "port map \("; \
		printf "connect => cddvd_conn\($$IDX\)"; \
		printf "\); "; \
		IDX=$$(expr $$IDX + 1); \
	done; \
	for i in $(DVD_IMAGE); do \
		FIXED_IMG=$$(echo "$$i" | sed -e "s/[^a-zA-Z0-9]//g"); \
		printf "$$FIXED_IMG : media_gen_dvd "; \
		printf "generic map \("; \
		printf "media => \\\\\"DVD-ROM\\\\\", "; \
		printf "iso => \\\\\"$$FIXED_IMG\\\\\"";\
		printf "\) "; \
		printf "port map \("; \
		printf "connect => cddvd_conn\($$IDX\)"; \
		printf "\); "; \
		IDX=$$(expr $$IDX + 1); \
	done; \
	);\
	\
	sed "s/-- @MEDIA_IMAGE_COMPS@/$$IMGS/" < $(HW_TEST_BENCH) \
		>> system.vhdl


else
	cat $(HW_TEST_BENCH) >> system.vhdl
endif

# generate intermediate code file from system.vhdl
system.ic: \
		system.vhdl \
		$(FAUM_DATA_DIR)/sigs_and_comps.vhdl \
		$(FAUM_DATA_DIR)/expect.vhdl \
		$(FAUHDLC)
	$(FAUHDLC) \
		--lib expect $(FAUM_DATA_DIR)/sigs_and_comps.vhdl \
		--lib expect $(FAUM_DATA_DIR)/expect.vhdl \
		--lib expect system.vhdl \
		-o system.ic

# perform experiment
experiment: \
		system.ic \
		$(ACTUAL_MEDIA) \
		simulation.setup
	faum-node-pc > log.faum-expect 2> log.faum-node.pc

# link only, if simulation.setup is not a local file
# (SIMSETUP can point to EXP_DIR/simulation.setup, or to
#  the default one in FAUM_DATA_DIR)
ifneq ($(realpath $(SIMSETUP)),$(realpath simulation.setup))
simulation.setup: $(SIMSETUP)
	ln -sf $< .
endif

# clean up
clean distclean::
	$(RM) system.ic
	$(RM) system.vhdl
	$(RM) log.*
	$(RM) -r node.*
	if [ -h simulation.setup ]; then \
		$(RM) simulation.setup; \
	fi
	# remove links to fixed image names
	for i in $(DVD_IMAGE) $(CDROM_IMAGE); do \
		FIXED_IMG=$$(echo "$$i" | sed -e "s/[^a-zA-Z0-9]//g"); \
		if [ -h "$$FIXED_IMG" ]; then \
			$(RM) "$$FIXED_IMG"; \
		fi; \
	done

# if run from a different directory, need a rule to create a local
# generate file, in case there is a static generate file in 
# EXP_DIR. (otherwise the Makefile must define its own rule to 
# create a generate file in the current directory)
ifneq ($(shell cd $(EXP_DIR);/bin/pwd),$(shell /bin/pwd))
ifneq ($(wildcard $(EXP_DIR)/generate),)
generate:: $(EXP_DIR)/generate
	ln -sf $<

clean distclean::
	$(RM) generate
endif
endif

# include CDROM.images Makefile to create CDROM images in local directory
CDROM_REL_PATH := share/faumachine/experiments/CDROM.images/Makefile
CDROM_IMAGES_MK := \
	$(firstword \
		$(wildcard ../CDROM.images/Makefile \
			$(FAUM_INST_DIR)/$(CDROM_REL_PATH)))

ifeq ($(CDROM_IMAGES_MK),)
$(error Could not detect CDROM.images directory)
endif
include $(CDROM_IMAGES_MK)

.PHONY: all clean distclean experiment
