/*
 * $Id: telephone_isp_gui.c,v 1.8 2009-06-03 11:34:11 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "telephone_isp_gui.h"

#ifdef HAVE_GTK
#include "telephone_isp_gui_gtk.h"
#endif

void *
telephone_isp_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_telephone *port_phone,
	struct sig_boolean *port_switch
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return telephone_isp_gui_gtk_create(page, name,
				port_manage,
				port_phone, port_switch);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void 
telephone_isp_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		telephone_isp_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
