/*
 * $Id: faum-dev-test.c,v 1.7 2010-11-08 08:28:08 vrsieh Exp $
 *
 * $Id: faum-dev-test.c,v 1.7 2010-11-08 08:28:08 vrsieh Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <inttypes.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>

#include "faum-dev.h"

static int fd;

static uint32_t
c0rl(uint32_t addr)
{
	struct faum_dev_param param;
	int ret;

	param.addr = addr;
	param.bs = 0xf;
	ret = ioctl(fd, FAUM_DEV_C0R, &param);
	assert(0 <= ret);

	return param.data;
}

static void
c0wl(uint32_t addr, uint32_t val)
{
	struct faum_dev_param param;
	int ret;

	param.addr = addr;
	param.bs = 0xf;
	param.data = val;
	ret = ioctl(fd, FAUM_DEV_C0W, &param);
	assert(0 <= ret);
}

int
main(void)
{
	uint32_t membase;
	uint32_t iobase;
	unsigned int region;
	uint32_t addr;
	int ret;

	fd = open("/dev/faum-dev0", O_RDWR);
	assert(0 <= fd);

	/* Set base addresses. */
	membase = 0xd0000000;
	iobase = 0xe000;

	for (region = 0; region < 6; region++) {
		uint32_t size;

		c0wl(0x10 + region * 4, 0xffffffff);
		size = c0rl(0x10 + region * 4);
		if (size == 0x00000000
		 || size == 0xffffffff) {
			/* Invalid */
			continue;
		}

		switch (c0rl(0x10 + region * 4) & 1) {
		case 0: /* Memory region. */
			size &= ~0xf;
			size = ~size + 1;

			membase += size - 1;
			membase &= ~(size - 1);

fprintf(stderr, "0x%x: mem 0x%x\n", 0x10 + region * 4, size);
			c0wl(0x10 + region * 4, membase);

			membase += size;
			break;

		case 1: /* I/O region. */
			size &= ~0xf;
			size = ~size + 1;

			iobase += size - 1;
			iobase &= ~(size - 1);

fprintf(stderr, "0x%x: i/o 0x%x\n", 0x10 + region * 4, size);
			c0wl(0x10 + region * 4, iobase);

			iobase += size;
			break;
		}
	}

	/* Enable I/O and memory accesses. */
	c0wl(4, c0rl(4) | 3);

	for (addr = 0; addr < 64; addr += 4) {
		printf("0x%02x: 0x%08x\n", addr, c0rl(addr));
	}

	ret = close(fd);
	assert(0 <= ret);

	return 0;
}
