/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SERIAL_H_INCLUDED
#define __SERIAL_H_INCLUDED

#include "compiler.h"

extern unsigned char
serial_write(unsigned char c, unsigned short port);

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

extern unsigned short serial_read(unsigned short port);
extern unsigned short serial_getstatus(unsigned short port);

#endif /* RUNTIME_RM */
/* ==================== INIT_RM ==================== */
#ifdef INIT_RM

#define SER_RWBUFFER	(serport + 0)
#define SER_DIVLO	(serport + 0)
#define SER_DIVHI	(serport + 1)
#define SER_INTENABLE	(serport + 1)
#define SER_LINESTATUS	(serport + 5)
#define SER_MODEMSTATUS	(serport + 6)

#define SERIAL_CONSOLE 2

extern void serial_putcstr(CONST char *str, unsigned char port);
extern void serial_colwrite(unsigned char c, unsigned char col, unsigned char port);
extern void serial_reset(void);
extern void serial_gotoxy(unsigned char x, unsigned y);
extern unsigned short serial_init(unsigned char param, unsigned short port);

#endif /* INIT_RM */

#endif /* __SERIAL_H_INCLUDED */
