/*
 * fbgetty 
 * Copyright (C) 1999 2000 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#include <fbgetty/global.h>


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <syslog.h>


#include <fbgetty/options.h>
#include <fbgetty/vt.h>
#include <fbgetty/errors.h>

extern int
my_vsyslog(int priority, const char *format, va_list args);

/* an atexit like */
void
fgexit(int exit_code)
{
  fgcleanup();

  free(fgoptions_free(fgoptions));

  exit(exit_code);
}


/* do some clean up before exiting, in case or error */
void
fgcleanup(void)
{

#ifdef USE_VT_SWITCHING
  if (fgoptions->master == TRUE)
    vt_handler_restore();
#endif

#ifdef USE_FRAME_BUFFER 
  if (fgoptions->fb_fd > 2)
    {
      close (fgoptions->fb_fd);
    }

  if (fgoptions->fb_device != NULL)
    {
      free(fgoptions->fb_device);
      fgoptions->fb_device = NULL;
    }
#endif

  if (fgoptions->tty_fd > 2)
    {
      close (fgoptions->tty_fd);
      fgoptions->tty_fd = -1;
    }

  if (fgoptions->tty_device != NULL)
    {
      free(fgoptions->tty_device);
      fgoptions->tty_device = NULL;
    }
}

void 
fatal_error (const char *fmt, ...)
{
  va_list va_alist;
  
  va_start (va_alist, fmt);
  my_vsyslog (LOG_ERR, fmt, va_alist);
  va_end (va_alist);

  closelog ();
 
  fgexit (EXIT_FAILURE);
}

void 
error (const char *fmt, ...)
{
  va_list va_alist;
  
  va_start (va_alist, fmt);
  my_vsyslog (LOG_ERR, fmt, va_alist);
  va_end (va_alist);
  
  return;
}

void
message(const char *fmt, ...)
{
  va_list va_alist;
  
  va_start (va_alist, fmt);
  my_vsyslog (LOG_INFO, fmt, va_alist);
  va_end (va_alist);
  
  return;
}
