/***************************************************************************
 *   С뷨(Free Chinese Input Toys for X, FCITX)                   *
 *   Yuking(yuking_net@sohu.com)д                                           *
 *   Э: GPL                                                              *
 *   FCITX( A Chinese XIM Input Method) by Yuking (yuking_net@sohu.com)    *
 *                                                                         *
 *   Copyright (C) 2002~2005 by Yuking                                     *
 *   yuking_net@sohu.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * @file   main.c
 * @author Yuking yuking_net@sohu.com
 * @date   2008-1-16
 *
 * @brief  
 *
 *
 */

#include <langinfo.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "version.h"

#include "main.h"
#include "MyErrorsHandlers.h"
#include "tools.h"
#include "ui.h"
#include "MainWindow.h"
#include "InputWindow.h"
#include "vk.h"
#include "ime.h"
#include "table.h"
#include "punc.h"
#include "py.h"
#include "sp.h"
#include "about.h"
#include "QuickPhrase.h"
#include "AutoEng.h"

#ifndef CODESET
#define CODESET 14
#endif

extern Display *dpy;
extern Window   inputWindow;

extern Bool     bIsUtf8;

extern HIDE_MAINWINDOW hideMainWindow;

int main (int argc, char *argv[])
{
    XEvent          event;
    int             c; 	//ڱûĲ
    Bool            bBackground = True;
    char	    *imname=(char *)NULL;

    while((c = getopt(argc, argv, "dDn:vh")) != -1) {
        switch(c){
            case 'd':
                /* nothing to do */
                break;
            case 'D':
                bBackground = False;
                break;
	    case 'n':
	    	imname=optarg;
		break;
            case 'v':	//汾
                Version();
                return 0;
            case 'h':	//hκβϷĲϢ
            case '?':
                Usage();
                return 0;
        }
    }

    /*дڼ鵱ǰϵͳʹõǷUTFַ൱ַնִ
     * locale charmap
     */
    setlocale (LC_CTYPE, "");
    bIsUtf8 = (strcmp (nl_langinfo (CODESET), "UTF-8") == 0);

    /* ȳʼ X ټļΪÿݼ keysym ת
     * keycode ʱҪ Display
     */
    if (!InitX ())
	exit (1);

    /*ûļͨǡ~/.fcitx/configļھʹӰװĿ¼п
     * /data/config~/.fcitx/config
     */
    LoadConfig (True);

    /*塣ʵϣǸûãʹxftȡϢ
     * xftx11ṩĴغ
     */
    CreateFont ();
    //봰ڵĸ߶
    CalculateInputWindowHeight ();
    /*ļļûõģڼ¼fctix״̬ģ
     * ȫǻǰǵȵȡͨǡ~/.fcitx/profileļھʹӰװ
     * Ŀ¼п/data/profile~/.fcitx/profile
     */
    LoadProfile ();

    //ֵļ
    LoadPuncDict ();
    //س
    LoadQuickPhrase ();
    /* ~/.fcitx/AutoEng.dat ڣ
     *  /usr/local/share/fcitx/data/AutoEng.dat
     * ȡҪԶתӢ״̬
     */
    LoadAutoEng ();

    //ǽĴ

    CreateMainWindow ();	//ڣ뷨״̬
    CreateVKWindow ();		//ѡʴ
    CreateInputWindow ();	//봰
    CreateAboutWindow ();	//ڴ

    //ɫѡʴڵɫҲڡ~/.fcitx/configЩɫϢ
    InitGC (inputWindow);

    //뵽뷨飬ϵͳʹַ
    SetIM ();

    //ڵʾ
    if (hideMainWindow != HM_HIDE) {
	DisplayMainWindow ();
	DrawMainWindow ();
    }

    //ʼ뷨
    if (!InitXIM (inputWindow, imname))
	exit (4);

    //Ժ̨ʽ
    if (bBackground) {
	pid_t           id;

	id = fork ();
	if (id == -1) {
	    printf ("Can't run as a daemon\n");
	    exit (1);
	}
	else if (id > 0)
	    exit (0);
    }

    //ѭXWindowϢѭ
    for (;;) {
	XNextEvent (dpy, &event);					//ȴһ¼

	if (XFilterEvent (&event, None) == True)	//ǳʱȴһ¼
	    continue;

	MyXEventHandler (&event);					//¼
    }

    return 0;
}

void Usage ()
{
    printf("Usage: fcitx [OPTION]\n"
           "\t-d\t\trun as daemon(default)\n"
           "\t-D\t\tdon't run as daemon\n"
	   "\t-n[im name]\trun as specified name\n"
           "\t-v\t\tdisplay the version information and exit\n"
           "\t-h\t\tdisplay this help and exit\n");
}

void Version ()
{
    printf ("fcitx version: %s-%s\n", FCITX_VERSION, USE_XFT);
}
