/*
 * Copyright (C) 2002 Stephan Engstrm
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * o Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * o Neither the name of the ferite software nor the names of its contributors may
 *   be used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __FERITE_BUFFER_H__
#define __FERITE_BUFFER_H__

#define FE_DEFAULT_BUFFER_SIZE  1024

FeriteBuffer *ferite_buffer_new( size_t size );
void ferite_buffer_add( FeriteBuffer *buf, void *ptr, size_t size );
void *ferite_buffer_alloc( FeriteBuffer *buf, size_t size );
void ferite_buffer_add_char( FeriteBuffer *buf, int character );
void ferite_buffer_add_fstr( FeriteBuffer *buf, FeriteString *str );
void ferite_buffer_add_str( FeriteBuffer *buf, char *str );
void ferite_buffer_add_long( FeriteBuffer *buf, long data );
void ferite_buffer_add_double( FeriteBuffer *buf, double data );
void ferite_buffer_add_variable( FeriteScript *script, FeriteBuffer *buf, FeriteVariable *v );
int ferite_buffer_printf( FeriteBuffer *buf, char *fmt, ... );
int ferite_buffer_vprintf( FeriteBuffer *buf, char *fmt, va_list *args );
void ferite_buffer_merge( FeriteBuffer *dest, FeriteBuffer *source );
void ferite_buffer_delete( FeriteBuffer *buf );

int ferite_buffer_get_size( FeriteBuffer *buf );
void *ferite_buffer_get( FeriteBuffer *buf, int *len );
int ferite_buffer_to_fd( FeriteBuffer *buf, int fd );
int ferite_buffer_to_file( FeriteBuffer *buf, FILE *f );
FeriteVariable *ferite_buffer_to_var( FeriteBuffer *buf );
FeriteString *ferite_buffer_to_str( FeriteBuffer *buf );
FeriteVariable *ferite_sprintf(char *format, FeriteVariable **params );
int ferite_format( FeriteBuffer *buf, char *format, FeriteVariable **params );

#endif /* __FERITE_BUFFER_H__ */

