/* This file has been automatically generated by builder part of the ferite distribution */
/* file: array_Array.c */
/* namespace: Array */

#include <ferite.h>       /* we need this without a doubt */
#include "array_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( array_Array_getName_an )
{
   FeriteUnifiedArray *a;
   double index;

   ferite_get_parameters( params, 2, &a, &index );

   { /* Main function body. */
#line 180 "array.fec"

    
        long rindex = (long)index;
        FeriteString *str = NULL;
        FeriteVariable *var = NULL;
        
        if( a->size > rindex )
        {
            var = a->array[rindex];
            str = ferite_str_new( var->name, 0, FE_CHARSET_DEFAULT );
        }
        else
          str = ferite_str_new( "", 0, FE_CHARSET_DEFAULT );
        FE_RETURN_STR( str, FE_TRUE );        
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_size_a )
{
   FeriteUnifiedArray *a;

   ferite_get_parameters( params, 1, &a );

   { /* Main function body. */
#line 52 "array.fec"

    
        FE_RETURN_LONG( a->size );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_shift_a )
{
   FeriteUnifiedArray *a;

   ferite_get_parameters( params, 1, &a );

   { /* Main function body. */
#line 133 "array.fec"

    
        FeriteVariable *var = ferite_uarray_shift( script, a );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_unshift_av )
{
   FeriteUnifiedArray *a;
   FeriteVariable *var = params[1];

   ferite_get_parameters( params, 2, &a, NULL );

   { /* Main function body. */
#line 121 "array.fec"

    
        ferite_uarray_unshift( script, a, var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_join_as )
{
   FeriteUnifiedArray *a;
   FeriteString *value;

   ferite_get_parameters( params, 2, &a, &value );

   { /* Main function body. */
#line 295 "array.fec"

    
        char *string, *join = "";
        FeriteString *str = NULL;
        FeriteBuffer *buf = ferite_buffer_new(0);
        FeriteVariable *var = NULL;
        int i, len;

        for (i=0;i<a->size;i++)
        {

            if( a->array[i] != NULL )
            {
                str = ferite_variable_to_str( script, a->array[i], FE_FALSE );
                if( str != NULL )
                  ferite_buffer_printf(buf,"%s%.*s", join, str->length, str->data);
                ferite_str_destroy( str );
            }
            if(!i)
              join = value->data;
        }
        string = ferite_buffer_get(buf, &len);
        ferite_buffer_delete(buf);

        var = fe_new_str_static("joined_array", string, len, FE_CHARSET_DEFAULT );
        ffree( string );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_del_av )
{
   FeriteUnifiedArray *a;
   FeriteVariable *var = params[1];

   ferite_get_parameters( params, 2, &a, NULL );

   { /* Main function body. */
#line 149 "array.fec"

    
        ferite_uarray_del_var( script, a, var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_valueExists_av )
{
   FeriteUnifiedArray *a;
   FeriteVariable *value = params[1];

   ferite_get_parameters( params, 2, &a, NULL );

   { /* Main function body. */
#line 251 "array.fec"

    
        int i;

        for (i=0;i<a->size;i++)
        {
            if(a->array[i]->type == value->type)
            {
                switch(value->type)
                {
                  case F_VAR_STR:
                    if (ferite_str_cmp(VAS(a->array[i]), VAS(value)))
                      FE_RETURN_TRUE;
                    break;
                  case F_VAR_LONG:
                    if (VAI(a->array[i]) == VAI(value))
                      FE_RETURN_TRUE;
                    break;
                  case F_VAR_DOUBLE:
                    if (VAF(a->array[i]) == VAF(value))
                      FE_RETURN_TRUE;
                    break;
                  case F_VAR_OBJ:
                    if (VAO(a->array[i]) == VAO(value))
                      FE_RETURN_TRUE;
                    break;
                  case F_VAR_UARRAY:
                    if (ferite_uarray_cmp(script, VAUA(a->array[i]), VAUA(value)))
                      FE_RETURN_TRUE;
                    break;
                }
            }
        }
        FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_print_a )
{
   FeriteUnifiedArray *vars;

   ferite_get_parameters( params, 1, &vars );

   { /* Main function body. */
#line 205 "array.fec"

    
        FeriteIterator *iter;
        FeriteHashBucket *buk;
        iter = ferite_create_iterator(script);

        while((buk = (FeriteHashBucket*)ferite_hash_walk(script,vars->hash,iter)) != NULL)
        {
            printf("['%s'] = ",buk->id);
            if(((FeriteVariable *)(buk->data))->type == F_VAR_STR)
            {
                printf("'%.*s'\n",FE_STRLEN(((FeriteVariable*)(buk->data))), FE_STR2PTR(((FeriteVariable*)(buk->data))));
            }
            else
            {
                printf("<Ferite %s>\n", ferite_variable_id_to_str(script,((FeriteVariable*)(buk->data))->type));
            }
        }
        ffree(iter);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_pop_a )
{
   FeriteUnifiedArray *a;

   ferite_get_parameters( params, 1, &a );

   { /* Main function body. */
#line 108 "array.fec"

    
        FeriteVariable *var = ferite_uarray_pop( script, a );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_keys_a )
{
   FeriteUnifiedArray *a;

   ferite_get_parameters( params, 1, &a );

   { /* Main function body. */
#line 68 "array.fec"

    
        FeriteVariable *array, *var;
        char buf[512];
        FeriteHashBucket *buk;
        FeriteIterator *iter;
        int t = 0;

        array = ferite_create_uarray_variable(script,"Array.keys", a->hash->size, FE_STATIC);
        iter = ferite_create_iterator(script);
        while( (buk = (FeriteHashBucket*)ferite_hash_walk(script, a->hash,iter)) != NULL )
        {
            snprintf(buf,512,"index-%d",t);
            var = fe_new_str( buf, buk->id, 0, FE_CHARSET_DEFAULT );
            ferite_uarray_add( script, VAUA(array), var, NULL, FE_ARRAY_ADD_AT_END );
            t++;
        }
        ffree(iter);
        FE_RETURN_VAR(array);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_push_av )
{
   FeriteUnifiedArray *a;
   FeriteVariable *var = params[1];

   ferite_get_parameters( params, 2, &a, NULL );

   { /* Main function body. */
#line 96 "array.fec"

    
        ferite_uarray_push( script, a, var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_keyExists_as )
{
   FeriteUnifiedArray *a;
   FeriteString *key;

   ferite_get_parameters( params, 2, &a, &key );

   { /* Main function body. */
#line 234 "array.fec"

    
        if( ferite_hash_get( script, a->hash, key->data ) != NULL )
        {
            FE_RETURN_TRUE;
        }
        FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_getIndex_as )
{
   FeriteUnifiedArray *a;
   FeriteString *var;

   ferite_get_parameters( params, 2, &a, &var );

   { /* Main function body. */
#line 162 "array.fec"

    
        FeriteVariable *ptr = ferite_hash_get( script, a->hash, var->data );
        if( ptr != NULL )
        {
            FE_RETURN_LONG(ptr->index);
        }
        FE_RETURN_LONG(-1);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( array_Array_sort_an )
{
   FeriteUnifiedArray *a;
   double direction;

   ferite_get_parameters( params, 2, &a, &direction );

   { /* Main function body. */
#line 474 "array.fec"

    
        int i, j, type, add_pos;
	FeriteFunction *ff = NULL;
	struct sort_variable *arr;
        FeriteVariable *fv, *ret, *dup;

        if(!(ret = ferite_create_uarray_variable(script, "Array::sort",
                                                         a->size, FE_STATIC))) {
            FE_RETURN_VOID;
        }

        if(!(arr = fmalloc(a->size * sizeof(struct sort_variable)))) {
            FE_RETURN_VAR(ret);
        }

        if(a->size == 0) FE_RETURN_VAR(ret);

        for(i = 0; i < a->size; i++) {
            arr[i].var = ferite_uarray_get_index(script, a, i);
            /* This ugliness is because the compare function needs the script
             * pointer, but the standard libc qsort() function doesn't have the
             * ability to pass a context pointer to the compare function. So
             * we end up bundling the context pointer with every item in the
             * array to be sorted. */
	    arr[i].script = script;
        }

        if(a->size > 1) {

            /* Check that the members of the array are all the same type. We
             * also need to handle the special case of one being a double and
             * the other being a long: */
            for(i = 1; i < a->size; i++) {
                if((arr[i].var->type != arr[0].var->type) &&
                        !(arr[i].var->type == F_VAR_LONG && arr[0].var->type ==
                        F_VAR_DOUBLE) && !(arr[i].var->type == F_VAR_DOUBLE &&
                                             arr[0].var->type == F_VAR_LONG)) {
                    ffree(arr);
		    ferite_set_error(script, -1, "Variables in array to be "
                                        "sorted must all be of the same type");
                    FE_RETURN_VAR(ret);
                }
	    }

            /* If the members are objects, check that they are all of the same
             * class, and that the class has a suitable comparison function: */
            if(arr[0].var->type == F_VAR_OBJ) {
                for(i = 1; i < a->size; i++) {
                    if(VAO(arr[i].var)->oid != VAO(arr[0].var)->oid) {
                        ffree(arr);
                        ferite_set_error(script, -1, "Objects in array to be "
                                       "sorted must all be of the same class");
                        FE_RETURN_VAR(ret);
                    }
                }
                ff = ferite_class_get_function(script, VAO(arr[0].var)->klass,
                                                                   "compare");
                for(; ff; ff = ff->next) {
                    if(ff->signature[0] && ff->signature[0]->variable &&
                               ff->signature[0]->variable->type == F_VAR_OBJ &&
                               ff->signature[1] && ff->signature[1]->variable &&
                               ff->signature[1]->variable->type == F_VAR_OBJ &&
                                                            !ff->signature[2]) {
		       break;
                    }
                }
                if(!ff) {
                    ffree(arr);
                    ferite_set_error(script, -1, "No suitable compare function "
                              "found in the class of the objects to be sorted");
                    FE_RETURN_VAR(ret);
                }
            }

            /* The actual sort itself. fe_compare_vars() is in util.c */
            qsort(arr, a->size, sizeof(struct sort_variable), fe_compare_vars);
        }

        if((int)direction == 1) add_pos = FE_ARRAY_ADD_AT_START;
        else add_pos = FE_ARRAY_ADD_AT_END;
        for(i = 0; i < a->size; i++) {
	    if((dup = ferite_duplicate_variable(script, arr[i].var, NULL))) {
                ferite_uarray_add(script, VAUA(ret), dup, dup->name, add_pos);
            }
	}

        ffree(arr);
	FE_RETURN_VAR(ret);
    
   }
   FE_RETURN_VOID;
}

