/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  reflection_Object.c */
/* class: Object */

#include <ferite.h>       /* we need this without a doubt */
#include "reflection_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( reflection_Object_getVariables_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 403 "reflection.fec"

   
       FeriteHashBucket *buk;
       FeriteVariable *array, *var;
       FeriteHash *hash;
       FeriteIterator *iter;
       char *buf;
       int i;

       buf = FE_CLEAN_STRING(1024);
       array = ferite_create_uarray_variable(script, "Object::getVars", ObjectObj->variables->size, FE_STATIC);
       iter = ferite_create_iterator(script);
       while((buk = (FeriteHashBucket*)ferite_hash_walk(script,ObjectObj->variables,iter)) != NULL)
       {
	   var = buk->data;
	   
	   if( !FE_VAR_IS_STATIC(var) )
	   {
	       ferite_uarray_add(script,VAUA(array),
				 ferite_duplicate_variable(script,var, NULL),
				 var->name,FE_ARRAY_ADD_AT_END);
	   }
       }
       ffree( buf );
       ffree( iter );
       FE_RETURN_VAR(array);
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_getVariable_s )
{
   FeriteString *name;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &name, &super, &self );

   { /* Main function body. */
#line 315 "reflection.fec"

   
       FeriteVariable *var = ferite_object_get_var( script, ObjectObj, name->data );
       
       if( var == NULL )
       {
	   ferite_error( script, 0, "Object.getVariable(\"%s\") - No such variable in object\n", name->data );
	   FE_RETURN_VOID;
       }
       
       /* We dont do FE_RETURN_VAR because we dont want the variable to be disposed */
       return var;       
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_className_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 259 "reflection.fec"

   
       FeriteVariable *v;
       v = fe_new_str_static("className",ObjectObj->name, 0, FE_CHARSET_DEFAULT);
       FE_RETURN_VAR(v);
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_hasMember_os )
{
   FeriteObject *o;
   FeriteString *member;

   ferite_get_parameters( params, 2, &o, &member );

   { /* Main function body. */
#line 474 "reflection.fec"

   
       if( o != NULL )
       {
           if( ferite_object_get_var( script, o, member->data ) != NULL )
           {
               FE_RETURN_TRUE;
           }
           if( ferite_object_get_function( script, o, member->data ) != NULL )
           {
               FE_RETURN_TRUE;
           }
       }
       FE_RETURN_FALSE;
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_fromData_sa )
{
   FeriteString *klass;
   FeriteUnifiedArray *data;

   ferite_get_parameters( params, 2, &klass, &data );

   { /* Main function body. */
#line 281 "reflection.fec"

   
       FeriteVariable *obj = NULL;
       FeriteHashBucket *buk = NULL;
       FeriteIterator *iter = NULL;
       FeriteVariable *foo = NULL;
       FeriteClass *cls = ferite_find_class(script,script->mainns,klass->data);

       obj = ferite_build_object(script,cls);
       iter = ferite_create_iterator(script);
       while((buk = (FeriteHashBucket*)ferite_hash_walk(script,data->hash,iter)) != NULL)
       {
           if(ferite_object_has_var(script,VAO(obj),buk->id))
           {
               foo = fe_new_void_static( "no-var" );
               ferite_variable_destroy( script, ferite_op_assign( script, foo, (FeriteVariable*)buk->data ) );
               ferite_object_set_var(script, VAO(obj), buk->id, foo);
           }
       }
       ffree(iter);
       FE_RETURN_VAR( obj );
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_setVariables_a )
{
   FeriteUnifiedArray *vars;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &vars, &super, &self );

   { /* Main function body. */
#line 443 "reflection.fec"

   
       FeriteHashBucket *buk;
       FeriteIterator *iter;
       FeriteVariable *var;

       iter = ferite_create_iterator(script);
       while((buk = (FeriteHashBucket*)ferite_hash_walk(script,vars->hash,iter)) != NULL)
       {
           if(ferite_object_has_var(script,ObjectObj,buk->id))
           {
               var = ferite_duplicate_variable( script, buk->data, NULL );
               ferite_object_set_var(script,ObjectObj,buk->id,var);
           }
       }
       ffree(iter);
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_getObject_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 371 "reflection.fec"

   
       FE_RETURN_OBJECT( ObjectObj );
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_Destructor_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 248 "reflection.fec"

   
       ObjectObj->refcount--;
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_setVariable_sv )
{
   FeriteString *name;
   FeriteVariable *value = params[1];
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &name, NULL, &super, &self );

   { /* Main function body. */
#line 341 "reflection.fec"

   
       FeriteVariable *var = ferite_object_get_var( script, ObjectObj, name->data );
       FeriteVariable *rval = NULL;
       
       if( var == NULL )
       {
	   ferite_error( script, 0, "Object.setVariable(\"%s\") - No such variable in object\n", name->data );
	   FE_RETURN_VOID;
       }
       
       if( !ferite_types_are_equal( script, var->type, params[1]->type ) )
       {
	   ferite_error( script, 0, "Object.setVariable(\"%s\") - can't assign variable of type %s to type %s\n", 
			 name->data,
			 ferite_variable_id_to_str( script, params[1]->type ),
			 ferite_variable_id_to_str( script, var->type ) );
	   FE_RETURN_VOID;
       }
       
       rval = ferite_op_assign( script, var, params[1] );
       FE_RETURN_VAR( rval );
   
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( reflection_Object_Object_o )
{
   FeriteObject *obj;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &obj, &super, &self );

   { /* Main function body. */
#line 235 "reflection.fec"

   
       if(obj != NULL)
       {
           ObjectObj = obj;
	   obj->refcount++;
       }
       else
       {
           ferite_error(script,0,"Invalid object (a null object?)");
       }
   
   }
   FE_RETURN_VOID;
}

