#include <ferite.h>
#include "reflection_header.h"

void reflection_variable_get( FeriteScript *script, FeriteVariable *var )
{
    FeriteObject *object = var->accessors->odata;
    FeriteFunction *function = ferite_object_get_function( script, object, "get" );
    FeriteVariable **plist = ferite_create_parameter_list( 3 );
    FeriteVariable *rval = NULL;
    void *a = var->accessors;
    
    FE_ENTER_FUNCTION;
    
    if( function != NULL )
    {
	plist = ferite_object_add_self_variable_to_params( script, plist, object );
	rval = ferite_call_function( script, function, plist );

	if( rval->type != F_VAR_VOID )
	{
	    var->accessors = NULL;
	    ferite_variable_destroy( script, ferite_op_assign( script, var, rval ) );
	    var->accessors = a;
	}
	
	ferite_variable_destroy( script, rval );
    }
    ferite_delete_parameter_list( script, plist );
    
    FE_LEAVE_FUNCTION(NOWT);
}

void reflection_variable_set( FeriteScript *script, FeriteVariable *var, FeriteVariable *newvalue )
{
    FeriteObject *object = var->accessors->odata;
    FeriteFunction *function = ferite_object_get_function( script, object, "set" );
    FeriteVariable **plist = ferite_create_parameter_list( 4 );
    FeriteVariable *rval = NULL;
    void *a = var->accessors;
    
    FE_ENTER_FUNCTION;
    
    if( function != NULL )
    {
	plist = ferite_add_to_parameter_list( plist, ferite_duplicate_variable( script, newvalue, NULL ) );
	MARK_VARIABLE_AS_DISPOSABLE( plist[0] );
	
	plist = ferite_object_add_self_variable_to_params( script, plist, object );
	rval = ferite_call_function( script, function, plist );
	
	if( rval->type != F_VAR_VOID )
	{
	    var->accessors = NULL;
	    ferite_variable_destroy( script, ferite_op_assign( script, var, rval ) );
	    var->accessors = a;
	}
	
	ferite_variable_destroy( script, rval );
    }
    ferite_delete_parameter_list( script, plist );    
    FE_LEAVE_FUNCTION(NOWT);
}

void reflection_variable_cleanup( FeriteScript *script, void *odata )
{
    FeriteObject *object = odata;
    FeriteFunction *function = ferite_object_get_function( script, object, "cleanup" );
    FeriteVariable **plist = ferite_create_parameter_list( 3 );
    FeriteVariable *rval = NULL;
    
    FE_ENTER_FUNCTION;
    
    if( function != NULL )
    {
	plist = ferite_object_add_self_variable_to_params( script, plist, object );
	rval = ferite_call_function( script, function, plist );
	ferite_variable_destroy( script, rval );
    }
    ferite_delete_parameter_list( script, plist );

    object->refcount--;
    FE_LEAVE_FUNCTION(NOWT);
}
