/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  xml_treeparser.c */
/* class: treeparser */

#include <ferite.h>       /* we need this without a doubt */
#include "xml_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( xml_treeparser_pedantic_n )
{
   double bool;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &bool, &super, &self );

   { /* Main function body. */
#line 319 "xml.fec"

  
    if( !bool )
      xmlPedanticParserDefaultValue = 0;
    else
      xmlPedanticParserDefaultValue = 1;
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_saveToFile_s )
{
   FeriteString *filename;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &filename, &super, &self );

   { /* Main function body. */
#line 268 "xml.fec"

  
     XMLDoc *tree = self->odata;
 
     if( tree->doc ) 
	if( xmlSaveFormatFile( filename->data, tree->doc, 1 ))
	   FE_RETURN_TRUE;
     FE_RETURN_FALSE;
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_keep_blanks_n )
{
   double bool;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &bool, &super, &self );

   { /* Main function body. */
#line 305 "xml.fec"

  
    if( !bool )
      xmlKeepBlanksDefault(0);
    else
      xmlKeepBlanksDefault(1);
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_validation_n )
{
   double bool;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &bool, &super, &self );

   { /* Main function body. */
#line 291 "xml.fec"

  
    if( !bool )
      xmlDoValidityCheckingDefaultValue = 0;
    else
      xmlDoValidityCheckingDefaultValue = 1;
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_Destructor_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 159 "xml.fec"
 
  
      XMLDoc *tree = self->odata;

      if( tree->doc ) 
	xmlFreeDoc( tree->doc );
      
      if( tree )
	ffree( tree );
        
      xmlDoValidityCheckingDefaultValue = 0;
      xmlPedanticParserDefaultValue = 0;
      xmlKeepBlanksDefault(1);
      
      xmlSetGenericErrorFunc(NULL, NULL);
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_parseChunk_s )
{
   FeriteString *chunk;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &chunk, &super, &self );

   { /* Main function body. */
#line 205 "xml.fec"
 
  
      XMLDoc *tree = self->odata;

      if( tree->doc ) { 
	  xmlFreeDoc( tree->doc );
      	  tree->doc = NULL;
      }
      tree->doc = xmlParseMemory( chunk->data, chunk->length );
      if (tree->doc == NULL ) {
	ferite_warning( script, "Chunk was not parsed successfully. \n");
	FE_RETURN_FALSE;
      }
      tree->node = xmlDocGetRootElement( tree->doc );
      FE_RETURN_TRUE;
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_toString_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 245 "xml.fec"

  
     XMLDoc *tree = self->odata;
     xmlChar *string = NULL;
     int len;
     FeriteVariable *v;

     xmlIndentTreeOutput = 1;
     if( tree->doc ) 
	   xmlDocDumpMemoryEnc( tree->doc, &string, &len, NULL);
        
     v = fe_new_str_static( "xml", (char *)string, len, FE_CHARSET_DEFAULT );
     xmlFree( string );
     FE_RETURN_VAR( v );
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_xpathArray_s )
{
   FeriteString *expr;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &expr, &super, &self );

   { /* Main function body. */
#line 229 "xml.fec"

  
     FeriteVariable *v;
     XMLDoc *tree = self->odata;
 
     if(tree) 
	  v = ParseXPath( script, tree , (const char *) expr->data);
    FE_RETURN_VAR( v );
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_treeparser_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 146 "xml.fec"
 
  
      self->odata = fcalloc( 1, sizeof( XMLDoc ) );

      /* set default parser behavior */
      xmlSetGenericErrorFunc(stderr, 
			     (xmlGenericErrorFunc)tree_error_handler);
      xmlDoValidityCheckingDefaultValue = 0;
      xmlPedanticParserDefaultValue = 0;
      xmlKeepBlanksDefault(1);	
  
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( xml_treeparser_parseFile_s )
{
   FeriteString *filename;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &filename, &super, &self );

   { /* Main function body. */
#line 182 "xml.fec"
 
  
      XMLDoc *tree = self->odata;

      if( tree->doc ) { 
	  xmlFreeDoc( tree->doc );
      	  tree->doc = NULL;
      }
      tree->doc = xmlParseFile( filename->data );
      if (tree->doc == NULL ) {
	ferite_warning( script, "Document was not parsed successfully. \n");
	FE_RETURN_FALSE;
      }
      tree->node = xmlDocGetRootElement( tree->doc );
      FE_RETURN_TRUE;
  
   }
   FE_RETURN_VOID;
}

