/* This file has been automatically generated by builder part of the ferite distribution */
/* file: math_Math.c */
/* namespace: Math */

#include <ferite.h>       /* we need this without a doubt */
#include "math_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_math_Math_sqrt_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 379 "math.fec"

    
        if( num < 0 )
          ferite_error( script, 0, "Math.sqrt() can only take positive values\n" );
        else
        {
            FE_RETURN_DOUBLE( sqrt( num ) );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_numberFormat_nn )
{
   double num;
   double places;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &num, &places );

   { /* Main function body. */
#line 275 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_atan_n )
{
   double degree;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 110 "math.fec"

    
        FE_RETURN_DOUBLE( atan( degree ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_tan_n )
{
   double degree;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 396 "math.fec"

    
        FE_RETURN_DOUBLE( tan( degree ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_baseConvert_snn )
{
   FeriteString *num;
   double from;
   double to;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &num, &from, &to );

   { /* Main function body. */
#line 132 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_log10_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 225 "math.fec"

    
        if( num <= 0 )
          ferite_error( script, 0, "Math.log10() can only take positive values\n" );
        else
        {
            FE_RETURN_DOUBLE( log10( num ) );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_max_nn )
{
   double num1;
   double num2;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &num1, &num2 );

   { /* Main function body. */
#line 243 "math.fec"

    
        if( num1 < num2 )
        {
            FE_RETURN_DOUBLE( num2 );
        }
        else
        {
            FE_RETURN_DOUBLE( num1 );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_log_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 208 "math.fec"

    
        if( num <= 0 )
          ferite_error( script, 0, "Math.log() can only take positive values\n" );
        else
        {
            FE_RETURN_DOUBLE( log( num ) );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_rand_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 314 "math.fec"

    
        FE_RETURN_LONG( rand() );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_ceil_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 142 "math.fec"

    
        FE_RETURN_DOUBLE( ceil( num ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_isLong_n )
{
   double n;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &n );

   { /* Main function body. */
#line 424 "math.fec"

    
        if( params[0]->type == F_VAR_LONG )
        {
            FE_RETURN_TRUE;
        }
        FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_acos_n )
{
   double degree;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 73 "math.fec"

    
        if( degree < -1 || degree > 1 )
          ferite_error( script, 0, "Math.acos() can only take values between -1 and 1\n" );
        else
        {
            FE_RETURN_DOUBLE( acos( degree ) );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_cos_n )
{
   double degree;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 154 "math.fec"

    
        FE_RETURN_DOUBLE( cos( degree ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_rad2deg_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 302 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_getRandMax_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 194 "math.fec"

    
        FE_RETURN_LONG( RAND_MAX );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_deg2rad_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 162 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_hex2dec_s )
{
   FeriteString *num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 199 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_dec2hex_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 160 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_floor_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 183 "math.fec"

    
        FE_RETURN_DOUBLE( floor( num ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_round_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 354 "math.fec"

    
        int sign = (num < 0 ? -1 : 1 );
        FE_RETURN_LONG( (long)(num+(0.5 * sign)) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_oct2dec_s )
{
   FeriteString *num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 276 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_dec2oct_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 161 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_min_nn )
{
   double num1;
   double num2;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &num1, &num2 );

   { /* Main function body. */
#line 263 "math.fec"

    
        if( num1 > num2 )
        {
            FE_RETURN_DOUBLE( num2 );
        }
        else
        {
            FE_RETURN_DOUBLE( num1 );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_atan2_nn )
{
   double x;
   double y;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &x, &y );

   { /* Main function body. */
#line 127 "math.fec"

    
        FE_RETURN_DOUBLE( atan2( x, y ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_abs_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 56 "math.fec"

    
	if( params[0]->type == F_VAR_DOUBLE )
            FE_RETURN_DOUBLE( fabs( num ) );
        FE_RETURN_LONG( labs( (long)num ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_dec2bin_n )
{
   double num;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 159 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_bin2dec_s )
{
   FeriteString *bin;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &bin );

   { /* Main function body. */
#line 133 "math.fec"
{}
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_asin_n )
{
   double degree;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 93 "math.fec"

    
        if( degree < -1 || degree > 1 )
          ferite_error( script, 0, "Math.asin() can only take values between -1 and 1\n" );
        else
        {
            FE_RETURN_DOUBLE( asin( degree ) );
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_sin_n )
{
   double degree;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 367 "math.fec"

    
        FE_RETURN_DOUBLE( sin( degree ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_srand_n )
{
   double seed;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &seed );

   { /* Main function body. */
#line 335 "math.fec"

    
        srand( (long)seed );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_pow_nn )
{
   double base;
   double exp;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &base, &exp );

   { /* Main function body. */
#line 297 "math.fec"

    
        FE_RETURN_DOUBLE( pow( base, exp ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_pi_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 284 "math.fec"

    
        FE_RETURN_DOUBLE( M_PI );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_isDouble_n )
{
   double n;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &n );

   { /* Main function body. */
#line 408 "math.fec"

    
        if( params[0]->type == F_VAR_DOUBLE )
        {
            FE_RETURN_TRUE;
        }
        FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_math_Math_exp_n )
{
   double power;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &power );

   { /* Main function body. */
#line 171 "math.fec"

    
        FE_RETURN_DOUBLE( exp( power ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

