/* This file has been automatically generated by builder part of the ferite distribution */
/* file: sys_Network.c */
/* namespace: Network */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_sys_Network_getServiceByName_ss )
{
   FeriteString *name;
   FeriteString *proto;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &name, &proto );

   { /* Main function body. */
#line 792 "network.fec"

    
        char *prot;
        FeriteVariable *fv;
        struct servent *se;

        if(proto->data[0]) prot = proto->data;
        else prot = NULL;

        if(!(se = getservbyname(name->data, prot)))
          FE_RETURN_NULL_OBJECT;

        fv = servent_to_Service(script, se);
        FE_RETURN_VAR(fv);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_inet_ntoa_n )
{
   double ip;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &ip );

   { /* Main function body. */
#line 692 "network.fec"

    
        struct in_addr in;
        FeriteVariable *v;
        memset( &in, 0, sizeof( struct in_addr ) );
        in.s_addr = (long)ip;
        v = fe_new_str_static( "ip-addr", inet_ntoa( in ), 0, FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( v );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_getHostname_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 708 "network.fec"

    
        char buf[256];

        gethostname(buf, 256);

        FE_RETURN_VAR(ferite_create_string_variable_from_ptr(script,
                                                             "Hostname", buf, 0, FE_CHARSET_DEFAULT, FE_STATIC));
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_tcp_connect_snn )
{
   FeriteString *host;
   double port;
   double af;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &host, &port, &af );

   { /* Main function body. */
#line 418 "network.fec"

    
        FeriteClass *cls;
        struct sockaddr *sa = NULL;
        int sock, size, family = (int)af;
        FeriteVariable *fv, *object, **args;

        if(!(sa = make_sockaddr(script, host->data, (short)port, &family,&size)))
        {
            FE_RETURN_NULL_OBJECT;
        }

        if((sock = socket(family, SOCK_STREAM, 0)) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            ffree(sa);
            FE_RETURN_NULL_OBJECT;
        }

        if(connect(sock, sa, size) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            close(sock);
            ffree(sa);
            FE_RETURN_NULL_OBJECT;
        }

        if((cls = ferite_find_class(script, script->mainns, "Sys.TcpStream")))
        {
            args = ferite_create_parameter_list(4);
            args = ferite_add_to_parameter_list(args,fe_new_lng_static("socket", sock));
            MARK_VARIABLE_AS_DISPOSABLE(args[0]); /* automatically clear up */
            object = ferite_new_object(script, cls, args);
            ferite_delete_parameter_list(script, args);
            fv = ferite_object_get_var(script, VAO(object), "af");
            if(family == AF_INET)
              VAI(fv) = 0;
            else
              VAI(fv) = 1;
            set_remoteip(script, VAO(object), sa, VAI(fv));
            ffree(sa);
            FE_RETURN_VAR(object);
        }
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_unix_connect_s )
{
   FeriteString *path;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 557 "network.fec"

    
        FeriteVariable *obj, **args, *fv;
        FeriteClass *cls;
        struct sockaddr *sa;
        struct sockaddr_un un;
        int sock;

        if((sock = socket(PF_LOCAL, SOCK_STREAM, 0)) == -1)
          FE_RETURN_NULL_OBJECT;

        un.sun_family = AF_UNIX;
        if(path->length + 1 > sizeof(un.sun_path))
        {
            ferite_set_error(script, 0, "Path too long");
            FE_RETURN_NULL_OBJECT;
        }
        memcpy(un.sun_path, path->data, path->length + 1);
        sa = (struct sockaddr*)&un;

        if(connect(sock, sa, sizeof(struct sockaddr_un)) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            close(sock);
            FE_RETURN_NULL_OBJECT;
        }

        if((cls = ferite_find_class(script, script->mainns, "Sys.UnixStream")))
        {
            args = ferite_create_parameter_list(4);
            args = ferite_add_to_parameter_list(args,
                                                fe_new_lng_static("socket", sock));
            MARK_VARIABLE_AS_DISPOSABLE(args[0]); /* automatically clear up */
            obj = ferite_new_object(script, cls, args);
            ferite_delete_parameter_list(script, args);
            fv = ferite_create_string_variable(script, "path", path, FE_STATIC);
            ferite_object_set_var(script, VAO(obj), "path", fv);
            FE_RETURN_VAR(obj);
        }
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_unix_bind_s )
{
   FeriteString *path;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 612 "network.fec"

    
        FeriteVariable *obj, **args, *fv;
        FeriteClass *cls;
        struct sockaddr *sa;
        struct sockaddr_un un;
        int sock;

        if((sock = socket(PF_LOCAL, SOCK_STREAM, 0)) == -1)
          FE_RETURN_NULL_OBJECT;

        un.sun_family = AF_UNIX;
        if(path->length + 1 > sizeof(un.sun_path))
        {
            ferite_set_error(script, 0, "Path too long");
            FE_RETURN_NULL_OBJECT;
        }
        memcpy(un.sun_path, path->data, path->length + 1);
        sa = (struct sockaddr*)&un;

        if(bind(sock, sa, sizeof(struct sockaddr_un)))
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            close(sock);
            FE_RETURN_NULL_OBJECT;
        }
        if(listen(sock, 10))
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            close(sock);
            FE_RETURN_NULL_OBJECT;
        }
        if((cls = ferite_find_class(script, script->mainns, "Sys.UnixStream")))
        {
            args = ferite_create_parameter_list(4);
            args = ferite_add_to_parameter_list(args,
                                                fe_new_lng_static("socket", sock));
            obj = ferite_new_object(script, cls, args);
            ferite_delete_parameter_list(script, args);
            fv = ferite_create_string_variable(script, "path", path, FE_STATIC);
            ferite_object_set_var(script, VAO(obj), "path", fv);
            FE_RETURN_VAR(obj);
        }
        close(sock);
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_getServiceByPort_ns )
{
   double port;
   FeriteString *proto;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &port, &proto );

   { /* Main function body. */
#line 757 "network.fec"

    
        char *prot;
        FeriteVariable *fv;
        struct servent *se;

        if(proto->data[0]) prot = proto->data;
        else prot = NULL;

        if(!(se = getservbyport(htons((int)port), prot)))
          FE_RETURN_NULL_OBJECT;

        fv = servent_to_Service(script, se);
        FE_RETURN_VAR(fv);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_tcp_bind_snn )
{
   FeriteString *host;
   double port;
   double af;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &host, &port, &af );

   { /* Main function body. */
#line 491 "network.fec"

    
        FeriteClass *cls;
        struct sockaddr *sa;
        int sock, size, family = (int)af;
        FeriteVariable *fv, *object, **args;

        if(!(sa = make_sockaddr(script, host->data, (short)port, &family,
                                &size)))
        {
            FE_RETURN_NULL_OBJECT;
        }

        if((sock = socket(family, SOCK_STREAM, 0)) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            ffree(sa);
            FE_RETURN_NULL_OBJECT;
        }

        if(bind(sock, sa, size))
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            ffree(sa);
            close(sock);
            FE_RETURN_NULL_OBJECT;
        }

        if(listen(sock, 10))
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            ffree(sa);
            close(sock);
            FE_RETURN_NULL_OBJECT;
        }

        if((cls = ferite_find_class(script, script->mainns, "Sys.TcpStream")))
        {
            args = ferite_create_parameter_list(4);
            args = ferite_add_to_parameter_list(args,
                                                fe_new_lng_static("socket", sock));
            object = ferite_new_object(script, cls, args);
            ferite_delete_parameter_list(script, args);
            fv = ferite_object_get_var(script, VAO(object), "af");
            if(family == AF_INET) VAI(fv) = 0;
            else VAI(fv) = 1;
            ffree(sa);
            FE_RETURN_VAR(object);
        }
        close(sock);
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_inet_aton_s )
{
   FeriteString *host;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &host );

   { /* Main function body. */
#line 671 "network.fec"

    
        struct in_addr in;
        if( inet_aton( host->data, &in ) == 0 )
          FE_RETURN_FALSE;
        FE_RETURN_LONG( in.s_addr );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

