/* This file has been automatically generated by builder part of the ferite distribution */
/* file: sys_Sys.c */
/* namespace: Sys */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_sys_Sys_setgid_n )
{
   double gid;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &gid );

   { /* Main function body. */
#line 1949 "posix.fec"

    
        if(setgid((gid_t)gid) == -1)
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_lstat_s )
{
   FeriteString *filename;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 567 "posix.fec"

    
        struct stat *in;

        in = fmalloc( sizeof( struct stat ) );
        if( lstat( filename->data, in ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror( errno ) );
            FE_RETURN_NULL_OBJECT;
        }
        FE_RETURN_VAR( system_call_stat( script, in ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_geteuid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1886 "posix.fec"

    
        FE_RETURN_LONG( geteuid() );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_chown_snn )
{
   FeriteString *filename;
   double uid;
   double gid;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &filename, &uid, &gid );

   { /* Main function body. */
#line 488 "posix.fec"

    
        if(chown(filename->data, (uid_t)uid, (gid_t)gid) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_umask_n )
{
   double mask;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &mask );

   { /* Main function body. */
#line 98 "posix.fec"

    
        FE_RETURN_LONG(umask((mode_t)mask));
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_fork_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1832 "posix.fec"

    
        pid_t pid;
        if( ( pid  = fork() ) == -1 )
          ferite_set_error( script, errno, "%s", strerror(errno) );
        FE_RETURN_LONG( pid );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_utime_s )
{
   FeriteString *filename;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 527 "posix.fec"

    
        if(utime(filename->data, NULL) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_utime_snn )
{
   FeriteString *filename;
   double atime;
   double mtime;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &filename, &atime, &mtime );

   { /* Main function body. */
#line 513 "posix.fec"

    
        struct utimbuf ut;

        ut.actime = (time_t)atime;
        ut.modtime = (time_t)mtime;

        if(utime(filename->data, &ut) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_stderr_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 989 "std.fec"

    
        FE_RETURN_VAR( system_create_stream_object( script, "Sys.StdioStream", stderr ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_usleep_n )
{
   double usecs;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &usecs );

   { /* Main function body. */
#line 226 "std.fec"

    
        usleep( (unsigned long)usecs );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getVersion_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 170 "std.fec"

    
        FeriteVariable *v;
        v = fe_new_str_static( "version", "ferite "VERSION, 0, FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( v );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_opendir_s )
{
   FeriteString *path;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 219 "posix.fec"

    
        DIR *dir;
        FeriteClass *cls;
        FeriteBuffer *buf;
        struct dirent *dirent;
        FeriteVariable *obj, *str, **params;

        if(!(dir = opendir(path->data)))
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_NULL_OBJECT;
        }

        buf = ferite_buffer_new(0);

        while((dirent = readdir(dir)))
        {
            ferite_buffer_add_str(buf, dirent->d_name);
            ferite_buffer_add_str(buf, ENDOFLINE);
        }
        closedir(dir);
        str = ferite_buffer_to_var(buf);
        ferite_buffer_delete(buf);

        if(!(cls = ferite_find_class(script, script->mainns,
                                     "Sys.StringStream")))
        {
            FE_RETURN_NULL_OBJECT;
        }

        params = ferite_create_parameter_list(4);
        ferite_add_to_parameter_list(params, str);
        obj = ferite_new_object(script, cls, params);
        ferite_delete_parameter_list(script, params);
        FE_RETURN_VAR(obj);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_softlink_ss )
{
   FeriteString *oldpath;
   FeriteString *newpath;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &oldpath, &newpath );

   { /* Main function body. */
#line 357 "posix.fec"

    

        if( symlink( oldpath->data, newpath->data ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror( errno ) );
            FE_RETURN_FALSE;
        }
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_remove_s )
{
   FeriteString *filename;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 304 "posix.fec"

    
        if( remove( filename->data ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_access_ss )
{
   FeriteString *pathname;
   FeriteString *modes;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &pathname, &modes );

   { /* Main function body. */
#line 56 "posix.fec"

    
        int i;
        int mode = 0;

        for(i = 0; i < modes->length; i++)
        {
            switch(modes->data[i])
            {
              case 'r':
                mode |= R_OK;
                break;
              case 'w':
                mode |= W_OK;
                break;
              case 'x':
                mode |= X_OK;
                break;
              case 'f':
                mode |= F_OK;
                break;
            }
        }

        if(access(pathname->data, mode) == -1)
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_hardlink_ss )
{
   FeriteString *oldpath;
   FeriteString *newpath;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &oldpath, &newpath );

   { /* Main function body. */
#line 339 "posix.fec"

    
        if( link( oldpath->data, newpath->data ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_openprocess_ss )
{
   FeriteString *cmd;
   FeriteString *modes;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &cmd, &modes );

   { /* Main function body. */
#line 268 "posix.fec"

    
        FILE *process = popen( cmd->data, modes->data );
        if( process == NULL || (int)process == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_NULL_OBJECT;
        }
        FE_RETURN_VAR( system_create_stream_object( script, "Sys.ProcessStream", process ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_setpriority_nnn )
{
   double which;
   double who;
   double prio;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &which, &who, &prio );

   { /* Main function body. */
#line 2291 "posix.fec"

    
#ifdef HAVE_SETPRIORITY
        int i;

        switch((int)which)
        {
          default:
          case 0:
            i = PRIO_PROCESS;
            break;
          case 1:
            i = PRIO_PGRP;
            break;
          case 2:
            i = PRIO_USER;
            break;
        }
        errno = 0;
        if(setpriority(i, (int)who, (int)prio) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
#else
        ferite_set_error(script, EINVAL, "setpriority() is not supported by "
                         "this OS");
        FE_RETURN_FALSE;
#endif
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_openfile_sn )
{
   FeriteString *filename;
   double flags;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &filename, &flags );

   { /* Main function body. */
#line 138 "posix.fec"

    
        FeriteClass *cls;
        FeriteVariable *object, **args;
        int fd;

        if(( fd = open( filename->data, (int)flags )) != -1 )
        {
            if((cls = ferite_find_class( script, script->mainns, "Sys.FileStream" )) != NULL)
            {
                args = ferite_create_parameter_list_from_data( script, "l", fd );
                object = ferite_new_object( script, cls, args );
                ferite_delete_parameter_list( script, args );
                FE_RETURN_VAR( object );
            }
            close( fd );
        }
        else
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
        }
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getBuildDate_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 182 "std.fec"

    
        FeriteVariable *v;
        v = fe_new_str_static( "builddate", __DATE__" "__TIME__, 0, FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( v );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_chroot_s )
{
   FeriteString *path;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 437 "posix.fec"

    
        if(chroot(path->data) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_chdir_s )
{
   FeriteString *path;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 411 "posix.fec"

    
        if( chdir( path->data ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror( errno ) );
            FE_RETURN_FALSE;
        }
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_stdin_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 969 "std.fec"

    
        FE_RETURN_VAR( system_create_stream_object( script, "Sys.StdioStream", stdin ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_error_sn )
{
   FeriteString *message;
   double value;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &message, &value );

   { /* Main function body. */
#line 114 "std.fec"

    
        ferite_error( script, (long)value, "%.*s", message->length, message->data );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_mkfifo_sn )
{
   FeriteString *filename;
   double mode;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &filename, &mode );

   { /* Main function body. */
#line 115 "posix.fec"

    
        if(mkfifo(filename->data, (mode_t)mode) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_stdout_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 979 "std.fec"

    
        FE_RETURN_VAR( system_create_stream_object( script, "Sys.StdioStream", stdout ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_setsid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 2120 "posix.fec"

    
        pid_t ret;
        if((ret = setsid()) == -1)
          ferite_set_error(script, errno, "%s", strerror(errno));
        FE_RETURN_LONG(ret);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getgid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1920 "posix.fec"

    
        FE_RETURN_LONG( getgid() );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_strptime_ss )
{
   FeriteString *str;
   FeriteString *fmt;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &str, &fmt );

   { /* Main function body. */
#line 1736 "posix.fec"

    
#ifdef USING_DARWIN
        FE_RETURN_NULL_OBJECT;
#else
        FeriteVariable *v;
        struct tm tm;
        memset( &tm, 0, sizeof( struct tm ) );
        strptime( str->data, fmt->data, &tm );
        FE_RETURN_VAR( system_call_tm( script, &tm ) );
#endif
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_Time_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1445 "posix.fec"

    
        FE_RETURN_LONG( time(NULL) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_setuid_n )
{
   double uid;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &uid );

   { /* Main function body. */
#line 1904 "posix.fec"

    
        if(setuid((uid_t)uid) == -1)
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_mkdir_sn )
{
   FeriteString *dirname;
   double mode;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &dirname, &mode );

   { /* Main function body. */
#line 288 "posix.fec"

    
        if( mkdir( dirname->data, (mode_t)mode ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_system_s )
{
   FeriteString *cms;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &cms );

   { /* Main function body. */
#line 195 "std.fec"

    
        int ret;
        ret = system( cms->data );
        if( ret == -1 )
          ferite_set_error( script, -1, "'system()' failed" );
        FE_RETURN_LONG( WEXITSTATUS(ret) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_exec_saa )
{
   FeriteString *filename;
   FeriteUnifiedArray *argv;
   FeriteUnifiedArray *env;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &filename, &argv, &env );

   { /* Main function body. */
#line 2499 "posix.fec"

    
        int i;
        FeriteVariable *fv;
        char **cargv, **cenv;

        if(!(cargv = fcalloc(argv->size + 1, sizeof(char *))))
          FE_RETURN_FALSE;

        if(!(cenv = fcalloc(env->size + 1, sizeof(char *))))
        {
            ffree(cargv);
            FE_RETURN_FALSE;
        }

        for(i = 0; i < argv->size; i++)
        {
            fv = ferite_uarray_get_index(script, argv, i);
            if(fv->type != F_VAR_STR)
            {
                ferite_set_error(script, 0, "argv[%d] not a string", i);
                goto execfailed;
            }
            if(!(cargv[i] = fstrdup(VAS(fv)->data))) goto execfailed;
        }

        for(i = 0; i < env->size; i++)
        {
            fv = ferite_uarray_get_index(script, env, i);
            if(fv->type != F_VAR_STR)
            {
                ferite_set_error(script, 0, "env[%d] not a string", i);
                goto execfailed;
            }
            if(fv->name[0] == 0)
            {
                ferite_set_error(script, 0, "env[%d] doesn't have a key", i);
                goto execfailed;
            }
            if(!(cenv[i] = fmalloc(strlen(VAS(fv)->data) +
                                   strlen(fv->name) + 2)))
            {
                goto execfailed;
            }
            sprintf(cenv[i], "%s=%s", fv->name, VAS(fv)->data);
        }

        execve(filename->data, cargv, cenv);

  /* If we get to here, execve() failed because it shouldn't return. */

        ferite_set_error(script, errno, "%s", strerror(errno));

        execfailed:
        for(i = 0; cargv[i]; i++) ffree(cargv[i]);
        ffree(cargv);
        for(i = 0; cenv[i]; i++) ffree(cenv[i]);
        ffree(cenv);
        FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getppid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 2104 "posix.fec"

    
        FE_RETURN_LONG(getppid());
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_move_ss )
{
   FeriteString *oldpath;
   FeriteString *newpath;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &oldpath, &newpath );

   { /* Main function body. */
#line 321 "posix.fec"

    
        if( rename( oldpath->data, newpath->data ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
            FE_RETURN_FALSE;
        }
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getegid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1931 "posix.fec"

    
        FE_RETURN_LONG( getegid() );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_gmtime_n )
{
   double time;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &time );

   { /* Main function body. */
#line 1703 "posix.fec"

    
        struct tm *tm;
        time_t t;
        t = (time_t)time;
        tm = gmtime( &t );
        FE_RETURN_VAR( system_call_tm( script, tm ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_stat_s )
{
   FeriteString *filename;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 544 "posix.fec"

    
        struct stat *in;

        in = fmalloc( sizeof( struct stat ) );
        if( stat( filename->data, in ) == -1 )
        {
            ferite_set_error( script, errno, "%s", strerror( errno ) );
            FE_RETURN_NULL_OBJECT;
        }
        FE_RETURN_VAR( system_call_stat( script, in ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getpid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 2093 "posix.fec"

    
        FE_RETURN_LONG(getpid());
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_waitpid_nn )
{
   double pid;
   double nohang;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &pid, &nohang );

   { /* Main function body. */
#line 1860 "posix.fec"

    
        int rpid = waitpid((pid_t) pid, NULL, (int)nohang ? WNOHANG : 0);
        if(rpid == -1) ferite_set_error(script, errno, "%s", strerror(errno));
        FE_RETURN_LONG(rpid);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_timestamp_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 237 "std.fec"

    
        struct timeval the_time;
        double t = 0;

        gettimeofday(&the_time, NULL);

        t = the_time.tv_sec + (((float)the_time.tv_usec)/1000000);

        FE_RETURN_DOUBLE( t );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_scriptName_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 158 "std.fec"

    
        FeriteVariable *v;
        v = fe_new_str_static( "scriptname", script->filename, 0, FE_CHARSET_DEFAULT);
        FE_RETURN_VAR( v );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_sleep_n )
{
   double secs;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &secs );

   { /* Main function body. */
#line 215 "std.fec"

    
        FE_RETURN_LONG(sleep((unsigned int)secs));
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_strerror_n )
{
   double what;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &what );

   { /* Main function body. */
#line 125 "std.fec"

    
        char buf[1024];
        FeriteVariable *var;
        int Error = (int)what;

        switch( Error )
        {
          case -1:     sprintf(buf,"%d: Generic Error", Error); break;
          case  0:     sprintf(buf,"%d: Success", Error); break;
          default:     sprintf(buf,"%d: %s", Error, strerror(Error) );
            break;

        }
        var = fe_new_str_static( "System::strerror", buf, 0, FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_resetSigAction_n )
{
   double sig;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &sig );

   { /* Main function body. */
#line 2188 "posix.fec"

    
        if(set_signal_action(script, (int)sig, SIG_DFL) == -1) FE_RETURN_FALSE;

        ferite_signal_unregister_handler(script, (int)sig);

        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_localtime_n )
{
   double timestamp;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &timestamp );

   { /* Main function body. */
#line 1720 "posix.fec"

    
        struct tm *tm = NULL;
        time_t t;
        t = (time_t)timestamp;
        tm = localtime( &t );
        FE_RETURN_VAR( system_call_tm( script, tm ) );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_createfile_sn )
{
   FeriteString *filename;
   double mode;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &filename, &mode );

   { /* Main function body. */
#line 176 "posix.fec"

    
        FeriteClass *cls;
        FeriteVariable *object, **args;
        int fd;

        if(( fd = creat( filename->data, (int)mode )) != -1 )
        {
            if((cls = ferite_find_class( script, script->mainns, "Sys.FileStream" )) != NULL)
            {
                args = ferite_create_parameter_list_from_data( script, "l", fd );
                object = ferite_new_object( script, cls, args );
                ferite_delete_parameter_list( script, args );
                FE_RETURN_VAR( object );
            }
            close( fd );
        }
        else
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
        }
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_timezone_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1754 "posix.fec"

    
        FE_RETURN_LONG( 0 );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_openlog_snn )
{
   FeriteString *ident;
   double option;
   double facility;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &ident, &option, &facility );

   { /* Main function body. */
#line 51 "syslog.fec"

    
        FeriteClass *cls;
        FeriteVariable *obj;

        if((cls = ferite_find_class( script, script->mainns,
                                          "Sys.SyslogStream"))) {
            openlog(ident->data, (int)option, (int)facility);
            obj = ferite_new_object(script, cls, NULL);
            FE_RETURN_VAR(obj);
        }
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getpriority_nn )
{
   double which;
   double who;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &which, &who );

   { /* Main function body. */
#line 2241 "posix.fec"

    
#ifdef HAVE_GETPRIORITY
        int i;

        switch((int)which)
        {
          default:
          case 0:
            i = PRIO_PROCESS;
            break;
          case 1:
            i = PRIO_PGRP;
            break;
          case 2:
            i = PRIO_USER;
            break;
        }
        errno = 0;
        if((i = getpriority(i, (int)who)) == -1)
          ferite_set_error(script, errno, "%s", strerror(errno));
        FE_RETURN_LONG(i);
#else
        ferite_set_error(script, EINVAL, "getpriority() is not supported by "
                         "this OS");
        FE_RETURN_LONG(-1);
#endif
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_ignoreSignal_n )
{
   double sig;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &sig );

   { /* Main function body. */
#line 2208 "posix.fec"

    
        if(set_signal_action(script, (int)sig, SIG_IGN) == -1) FE_RETURN_FALSE;

        ferite_signal_unregister_handler(script, (int)sig);

        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getuid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1875 "posix.fec"

    
        FE_RETURN_LONG( getuid() );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getcwd_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 373 "posix.fec"

    
        int len = 128;
        FeriteVariable *v;
        char *buf, *ret = NULL;

        if((buf = fmalloc(len)))
        {
            do
            {
                if(!(ret = getcwd(buf, len - 1)) && errno == ERANGE)
                {
                    len *= 2;
                    buf = frealloc(buf, len);
                }
            }
            while(!ret && buf && errno == ERANGE);
        }

        if(ret)
        {
            v = fe_new_str_static("Sys::getcwd", ret, 0, FE_CHARSET_DEFAULT);
        }
        else
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            v = fe_new_str_static("", "", 0, FE_CHARSET_DEFAULT);
        }
        if(buf) ffree(buf);
        FE_RETURN_VAR(v);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_select_aaan )
{
   FeriteUnifiedArray *read;
   FeriteUnifiedArray *write;
   FeriteUnifiedArray *except;
   double timeout;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 4, &read, &write, &except, &timeout );

   { /* Main function body. */
#line 2616 "posix.fec"

    
        int selectret;
        FeriteClass *cls;
        fd_set rfds, wfds, efds;
        FeriteVariable *fv, *obj;
        struct timeval tv, endtime, newtime, *tvp;

        if(timeout < 0) tvp = NULL;
        else if(timeout > 0)
        {
            tv.tv_sec = (long)timeout;
            tv.tv_usec = (long)((timeout - tv.tv_sec) * 1000000);
            tvp = &tv;
            gettimeofday(&endtime, NULL);
            endtime.tv_usec += tv.tv_usec;
            endtime.tv_sec += tv.tv_sec;
            if(endtime.tv_usec >= 1000000)
            {
                endtime.tv_usec -= 1000000;
                endtime.tv_sec++;
            }
        }
        else
        {
            tv.tv_usec = 0;
            tv.tv_sec = 0;
            tvp = &tv;
        }

        do
        {
            if(make_fd_set(script, read, &rfds) == -1 ||
               make_fd_set(script, write, &wfds) == -1 ||
               make_fd_set(script, except, &efds) == -1)
            {
                FE_RETURN_NULL_OBJECT;
            }
            selectret = select(FD_SETSIZE, &rfds, &wfds, &efds, tvp);
            if(tvp && timeout)
            {
                gettimeofday(&newtime, NULL);
                if(newtime.tv_sec > endtime.tv_sec || (newtime.tv_sec ==
                                                       endtime.tv_sec && newtime.tv_usec >= endtime.tv_usec))
                {
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;
                }
                else
                {
                    tv.tv_sec = endtime.tv_sec - newtime.tv_sec;
                    tv.tv_usec = endtime.tv_usec - newtime.tv_usec;
                    if(tv.tv_usec < 0)
                    {
                        tv.tv_sec--;
                        tv.tv_usec += 1000000;
                    }
                }
            }
        }
        while(selectret == -1 && errno == EINTR);

        if(!(cls = ferite_find_class(script, script->mainns,
                                     "Sys.SelectResult")))
        {
            FE_RETURN_NULL_OBJECT;
        }

        if(!(obj = ferite_new_object(script, cls, NULL)))
          FE_RETURN_NULL_OBJECT;

        if(selectret && tvp && (tv.tv_usec > 0 || tv.tv_sec > 0))
        {
            fv = ferite_object_get_var(script, VAO(obj), "timeout");
            fv->type = F_VAR_DOUBLE;
            VAF(fv) = tv.tv_sec + (double)((double)tv.tv_usec / 1000000);
        }

        if(selectret)
        {
            update_SelectResult(script, VAO(obj), read, "read", &rfds);
            update_SelectResult(script, VAO(obj), write, "write", &wfds);
            update_SelectResult(script, VAO(obj), except, "except", &efds);
        }

        FE_RETURN_VAR(obj);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_registerSigHandler_nso )
{
   double sig;
   FeriteString *func;
   FeriteObject *o;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &sig, &func, &o );

   { /* Main function body. */
#line 2168 "posix.fec"

    
        set_signal_action(script, (int)sig, SIG_IGN);
        if( o != NULL )
          ferite_signal_register_object_handler( script, o, func->data, (int)sig );
        else
          ferite_signal_register_function_handler( script, func->data, (int)sig );
        set_signal_action(script, (int)sig, ferite_signal_handler);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_warning_s )
{
   FeriteString *message;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &message );

   { /* Main function body. */
#line 103 "std.fec"

    
        ferite_warning( script, "%.*s", message->length, message->data );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_gc_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 93 "std.fec"

    
        ferite_check_gc( script );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_chmod_sn )
{
   FeriteString *filename;
   double mode;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &filename, &mode );

   { /* Main function body. */
#line 462 "posix.fec"

    
        if(chmod(filename->data, (mode_t)mode) == -1)
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_kill_nn )
{
   double pid;
   double sig;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &pid, &sig );

   { /* Main function body. */
#line 2142 "posix.fec"

    
        if(kill((pid_t)pid, (int)sig))
        {
            ferite_set_error(script, errno, "%s", strerror(errno));
            FE_RETURN_FALSE;
        }
        else FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_exit_n )
{
   double retval;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &retval );

   { /* Main function body. */
#line 148 "std.fec"

    
        ferite_stop_execution( script, (int)retval );
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

