/*
 * Copyright (C) 2000-2003 Chris Ross and various contributors
 * Copyright (C) 1999-2000 Chris Ross
 * Copyright (C) 2004 Christian M. Stamgren
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <ferite.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include "xml_header.h"
#include "sax_handlers.h"

xmlParserInputPtr sax_resolveEntity(void *ctxt, const xmlChar *publicId, const xmlChar *systemId)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_internalSubset(void *ctxt, const xmlChar *name, const xmlChar *ExternalID, const xmlChar *SystemID)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_externalSubset (void *ctxt, const xmlChar *name, const xmlChar *ExternalID, const xmlChar *SystemID)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

xmlEntityPtr sax_getEntity (void *ctxt, const xmlChar *name)
{
    xmlEntityPtr en = xmlGetPredefinedEntity(name);
    return en;
}

xmlEntityPtr sax_getParameterEntity (void *ctxt, const xmlChar *name)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_entityDecl (void *ctxt, const xmlChar *name, int type, const xmlChar *publicId, const xmlChar *systemId, xmlChar *content)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_notationDecl(void *ctxt, const xmlChar *name, const xmlChar *publicId, const xmlChar *systemId)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_attributeDecl(void *ctxt, const xmlChar *elem, const xmlChar *name, int type, int def, const xmlChar *defaultValue, xmlEnumerationPtr tree)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_elementDecl(void *ctxt, const xmlChar *name, int type, xmlElementContentPtr content)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_unparsedEntityDecl(void *ctxt, const xmlChar *name, const xmlChar *publicId, const xmlChar *systemId, const xmlChar *notationName)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_setDocumentLocator (void *ctxt, xmlSAXLocatorPtr loc)
{
/*   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );*/
}

void sax_startDocument( void *ctxt )
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;

    if( (function = ferite_object_get_function( script, obj, "startDocument" )) != NULL )
    {
	params = ferite_create_parameter_list(2);
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
    }
}

void sax_endDocument( void *ctxt )
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;

    if( (function = ferite_object_get_function( script, obj, "endDocument" )) != NULL )
    {
        params = ferite_create_parameter_list(2);
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
    }
}

void sax_startElement (void *ctxt, const xmlChar *name, const xmlChar **atts)
{
    FeriteVariable        *array;
    int i = 0;
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL, *var = NULL;
    FeriteString          *tname;

    if( (function = ferite_object_get_function( script, obj, "startElement" )) != NULL )
    {
        tname = ferite_str_new((char *)name, 0, FE_CHARSET_DEFAULT);
        array = ferite_create_uarray_variable( NULL, "retval-string_split", 10, FE_STATIC );
        if( atts != NULL )
        {
            for( i = 0; atts[i] != NULL; i++ )
            {
                var = fe_new_str( (char *)atts[i], (atts[i++] == NULL ? "" : (char *)atts[i]), 0, FE_CHARSET_DEFAULT );
                ferite_uarray_add( script, VAUA( array ), var, (char *)atts[i-1], FE_ARRAY_ADD_AT_END );
            }
        }
        params = ferite_create_parameter_list_from_data( script, "sa", tname, VAUA(array) );
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
        ferite_variable_destroy( script, array );
        ferite_str_destroy( tname );
    }
}

void sax_endElement (void *ctxt, const xmlChar *name)
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;
    FeriteString          *tname;

    if( (function = ferite_object_get_function( script, obj, "endElement" )) != NULL )
    {
        tname = ferite_str_new((char *)name, 0, FE_CHARSET_DEFAULT);
        params = ferite_create_parameter_list_from_data( script, "s", tname );
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
        ferite_str_destroy( tname );
    }
}

void sax_attribute (void *ctxt, const xmlChar *name, const xmlChar *value)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_reference (void *ctxt, const xmlChar *name)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_characters (void *ctxt, const xmlChar *ch, int len)
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;
    FeriteString          *buf;

    if( (function = ferite_object_get_function( script, obj, "characters" )) != NULL )
    {
        buf = ferite_str_new((char *)ch, len, FE_CHARSET_DEFAULT);
        params = ferite_create_parameter_list_from_data( script, "s", buf );
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
        ferite_str_destroy( buf );
    }
}

void sax_ignorableWhitespace (void *ctxt, const xmlChar *ch, int len)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_processingInstruction (void *ctxt, const xmlChar *target, const xmlChar *data)
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;
    FeriteString          *name,*value;

    if( (function = ferite_object_get_function( script, obj, "pi" )) != NULL )
    {
        name = ferite_str_new((char *)target, 0, FE_CHARSET_DEFAULT);
        value = ferite_str_new((char *)data, 0, FE_CHARSET_DEFAULT);
        params = ferite_create_parameter_list_from_data( script, "ss", name, value );
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
        ferite_str_destroy( name );
        ferite_str_destroy( value );
    }
}

void sax_comment (void *ctxt, const xmlChar *value)
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;
    FeriteString          *buf;

    if( (function = ferite_object_get_function( script, obj, "comment" )) != NULL )
    {
        buf = ferite_str_new((char *)value, 0, FE_CHARSET_DEFAULT);
        params = ferite_create_parameter_list_from_data( script, "s", buf );
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
        ferite_str_destroy( buf );
    }
}

void sax_cdataBlock (void *ctxt, const xmlChar *value, int len)
{
    SaxRecord             *sr = ctxt;
    FeriteObject          *obj = sr->obj;
    FeriteScript          *script = sr->script;
    FeriteFunction        *function = NULL;
    FeriteVariable        **params = NULL;
    FeriteString          *buf;

    if( (function = ferite_object_get_function( script, obj, "cdata" )) != NULL )
    {
        buf = ferite_str_new((char *)value, len, FE_CHARSET_DEFAULT);
        params = ferite_create_parameter_list_from_data( script, "s", buf );
        ferite_variable_destroy( script, ferite_call_function( sr->script, obj, NULL, function, params ) );
        ferite_delete_parameter_list( script, params );
        ferite_str_destroy( buf );
    }
}

void sax_warning (void *ctxt, const char *msg, ...)
{
    SaxRecord             *sr = ctxt;
    va_list ap;

    va_start( ap, msg );
    ferite_vwarning( sr->script, (char *)msg, &ap );
    va_end( ap );
}

void sax_error (void *ctxt, const char *msg, ...)
{
    SaxRecord             *sr = ctxt;
    va_list ap;

    va_start( ap, msg );
    ferite_verror( sr->script, 0, (char *)msg, &ap );
    va_end( ap );
}

void sax_fatalError (void *ctxt, const char *msg, ...)
{
    SaxRecord             *sr = ctxt;
    va_list ap;

    va_start( ap, msg );
    ferite_verror( sr->script, (char *)msg, &ap );
    va_end( ap );
}

int sax_isStandalone (void *ctxt)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_hasInternalSubset (void *ctxt)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_hasExternalSubset (void *ctxt)
{
    printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_xmlParseFile( xmlSAXHandlerPtr sax, SaxRecord *obj, char *filename )
{
    xmlParserCtxtPtr ctxt = NULL;

    ctxt = xmlCreateFileParserCtxt( filename );
    if( ctxt == NULL )
    {
        ferite_error( obj->script, 0, "Unable to find file %s\n", filename );
        return 0;
    }
    ctxt->sax = sax;
    ctxt->userData = obj;

    return sax_xmlExecuteCtxt( ctxt );
}

int sax_xmlParseChunk( xmlSAXHandlerPtr sax, SaxRecord *obj, FeriteString *chunk )
{
    xmlParserCtxtPtr ctxt = NULL;

    ctxt = xmlCreateMemoryParserCtxt( chunk->data, chunk->length );
    if( ctxt == NULL )
    {
        ferite_error( obj->script, 0, "Unable to parse chunk: %s\n", chunk );
        return 0;
    }
    ctxt->sax = sax;
    ctxt->userData = obj;

    return sax_xmlExecuteCtxt( ctxt );
}

static int sax_xmlExecuteCtxt( xmlParserCtxtPtr ctxt )
{
    int ret = 0;
    xmlParseDocument( ctxt );

    if( ctxt->wellFormed )
      ret = 1;
    else
      ret = 0;

    if( ctxt->sax != NULL )
      ctxt->sax = NULL;

    xmlFreeParserCtxt( ctxt );

    return ret;
}
