/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.lang.reflect.Array;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;

public class BinaryTableHeaderParser {
    Header myHeader;

    public BinaryTableHeaderParser(Header myHeader) throws FitsException {
        int naxis1 = myHeader.getIntValue("NAXIS1", 0);
        this.checkLT0(naxis1, "NAXIS1 < 0 for binary table");
        int naxis2 = myHeader.getIntValue("NAXIS2", 0);
        this.checkLT0(naxis2, "NAXIS2 < 0 for binary table");
        int nfields = myHeader.getIntValue("TFIELDS", 0);
        this.checkLT0(nfields, "NFIELDS < 0 for binary table");
        this.myHeader = myHeader;
    }

    public Object[] getModelRow() throws FitsException {
        int nfields = this.myHeader.getIntValue("TFIELDS");
        Object[] row = new Object[nfields];
        for (int i = 0; i < nfields; ++i) {
            Object column = this.getColumnDef(i + 1);
            if (column == null) {
                throw new FitsException("Invalid TFORM for column " + (i + 1));
            }
            row[i] = column;
        }
        return row;
    }

    protected void checkLT0(int i, String errmsg) throws FitsException {
        if (i < 0) {
            throw new FitsException(errmsg);
        }
    }

    protected Object getColumnDef(int col) throws FitsException {
        int[] dims;
        Class<Number> baseType;
        int i;
        String format = this.myHeader.getStringValue("TFORM" + col);
        if (format == null) {
            throw new FitsException("No TFORM for column " + col);
        }
        for (i = 0; i < format.length() && Character.isSpaceChar(format.charAt(i)); ++i) {
        }
        while (i < format.length() && Character.isDigit(format.charAt(i))) {
            ++i;
        }
        boolean complex = false;
        boolean bitData = false;
        boolean varData = false;
        if (i >= format.length()) {
            throw new FitsException("Invalid TFORM value for column " + col);
        }
        int arrsiz = i > 0 ? Integer.parseInt(format.substring(0, i)) : 1;
        switch (format.charAt(i)) {
            case 'X': {
                baseType = Byte.TYPE;
                bitData = true;
                break;
            }
            case 'A': 
            case 'B': 
            case 'L': {
                baseType = Byte.TYPE;
                break;
            }
            case 'I': {
                baseType = Short.TYPE;
                break;
            }
            case 'J': {
                baseType = Integer.TYPE;
                break;
            }
            case 'K': {
                baseType = Long.TYPE;
                break;
            }
            case 'E': {
                baseType = Float.TYPE;
                break;
            }
            case 'D': {
                baseType = Double.TYPE;
                break;
            }
            case 'C': {
                baseType = Float.TYPE;
                complex = true;
                break;
            }
            case 'M': {
                baseType = Double.TYPE;
                complex = true;
                break;
            }
            case 'P': {
                baseType = Integer.TYPE;
                varData = true;
                if (arrsiz > 0) {
                    arrsiz = 2;
                    break;
                }
                arrsiz = 0;
                break;
            }
            default: {
                throw new FitsException("Invalid TFORM code '" + format.charAt(i) + "' for column " + col);
            }
        }
        String tdims = this.myHeader.getStringValue("TDIM" + col);
        if (tdims != null && !varData && !bitData) {
            dims = BinaryTableHeaderParser.getTDims(tdims, arrsiz);
        } else {
            if (bitData) {
                arrsiz /= 8;
            }
            dims = new int[]{arrsiz};
        }
        if (complex) {
            int[] ndims = new int[dims.length + 1];
            ndims[0] = 2;
            for (i = 1; i <= dims.length; ++i) {
                ndims[i] = dims[i - 1];
            }
            dims = ndims;
        }
        try {
            return Array.newInstance(baseType, dims);
        }
        catch (IllegalArgumentException e) {
            throw new FitsException("Invalid datatype");
        }
        catch (NegativeArraySizeException e) {
            throw new FitsException("Negative dimensions");
        }
    }

    public static int[] getTDims(String tdims, int arrsiz) {
        int ender;
        int[] backup = new int[]{arrsiz};
        int ncomma = 0;
        for (int i = 0; i < tdims.length(); ++i) {
            if (tdims.charAt(i) != ',') continue;
            ++ncomma;
        }
        int[] dims = new int[ncomma + 1];
        int starter = tdims.indexOf(40) + 1;
        if (starter < 0) {
            return backup;
        }
        for (int i = 0; i < ncomma; ++i) {
            ender = tdims.indexOf(44, starter);
            if (ender < 0) {
                return backup;
            }
            dims[i] = Integer.parseInt(tdims.substring(starter, ender));
            starter = ender + 1;
        }
        ender = tdims.indexOf(41, starter);
        if (ender < 0) {
            return backup;
        }
        dims[ncomma] = Integer.parseInt(tdims.substring(starter, ender));
        int[] newdims = new int[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            newdims[i] = dims[dims.length - i - 1];
        }
        return newdims;
    }

    public static Header pointToTable(BinaryTable table) throws FitsException {
        if (table == null) {
            throw new FitsException("Cannot create header for null table");
        }
        Header myHeader = new Header();
        return BinaryTableHeaderParser.pointToTable(table, myHeader);
    }

    public static Header pointToTable(BinaryTable table, Header myHeader) throws FitsException {
        myHeader.setXtension("BINTABLE");
        myHeader.setBitpix(8);
        myHeader.setNaxes(2);
        myHeader.setNaxis(1, 0);
        myHeader.setNaxis(2, table.getNrow());
        myHeader.setPcount(0);
        myHeader.setGcount(1);
        int[][] dimens = table.getDimens();
        int[] sizes = table.getSizes();
        char[] types = table.getTypes();
        myHeader.addIntValue("TFIELDS", dimens.length, "Number of fields in table");
        int mark = myHeader.getMark();
        String card = myHeader.getCard(mark);
        if (card != null && (card.substring(0, 8).equals("COMMENT ") || card.substring(0, 8).equals("        "))) {
            while (card.substring(0, 8).equals("COMMENT ") || card.substring(0, 8).equals("        ")) {
                card = myHeader.getCard(++mark);
            }
        } else {
            myHeader.insertCommentStyle("", "");
            myHeader.insertComment("End of required structural keywords");
            myHeader.insertCommentStyle("", "");
        }
        int rowsize = 0;
        for (int col = 0; col < dimens.length; ++col) {
            BinaryTableHeaderParser.pointToCol(myHeader, col, sizes[col], dimens[col], types[col]);
            int colsiz = sizes[col];
            if (types[col] == 'S') {
                colsiz *= 2;
            } else if (types[col] == 'I' || types[col] == 'F') {
                colsiz *= 4;
            } else if (types[col] == 'L' || types[col] == 'D') {
                colsiz *= 8;
            }
            rowsize += colsiz;
        }
        myHeader.addIntValue("NAXIS1", rowsize, "Number of bytes in row");
        return myHeader;
    }

    public static void addColumn(int column, Object[] col, Header myHeader) throws FitsException {
        int type;
        int bsize;
        int size;
        int[] dimens = ArrayFuncs.getDimensions(col[0]);
        if (dimens.length == 0) {
            size = 1;
            dimens = new int[]{1};
        } else {
            size = 1;
            for (int i = 0; i < dimens.length; ++i) {
                size *= dimens[i];
            }
        }
        Class base = ArrayFuncs.getBaseClass(col[0]);
        if (base == Boolean.TYPE) {
            bsize = 1;
            type = 90;
        } else if (base == Byte.TYPE) {
            bsize = 1;
            type = 66;
        } else if (base == Short.TYPE || base == Character.TYPE) {
            type = 83;
            bsize = 2;
        } else if (base == Integer.TYPE) {
            type = 73;
            bsize = 4;
        } else if (base == Long.TYPE) {
            type = 74;
            bsize = 8;
        } else if (base == Float.TYPE) {
            type = 70;
            bsize = 4;
        } else if (base == Double.TYPE) {
            type = 68;
            bsize = 8;
        } else {
            throw new FitsException("Invalid Column type");
        }
        BinaryTableHeaderParser.pointToCol(myHeader, column, size, dimens, (char)type);
        myHeader.addIntValue("TFIELDS", myHeader.getIntValue("TFIELDS") + 1, "Number of columns");
        myHeader.addIntValue("NAXIS1", myHeader.getIntValue("NAXIS1") + bsize * size, "Bytes per row");
        if (column == 0) {
            myHeader.addIntValue("NAXIS2", col.length, "Number of rows");
        }
    }

    static void pointToCol(Header myHeader, int col, int size, int[] dimens, char type) throws FitsException {
        String colTform;
        char desc;
        switch (type) {
            case 'Z': {
                desc = 'L';
                break;
            }
            case 'B': {
                desc = 'B';
                break;
            }
            case 'I': {
                desc = 'J';
                break;
            }
            case 'J': {
                desc = 'K';
                break;
            }
            case 'S': {
                desc = 'I';
                break;
            }
            case 'F': {
                desc = 'E';
                break;
            }
            case 'D': {
                desc = 'D';
                break;
            }
            default: {
                throw new FitsException("Invalid data type at column:" + col);
            }
        }
        StringBuffer tdim = new StringBuffer("(");
        for (int i = 0; i < dimens.length; ++i) {
            int dim = dimens[dimens.length - i - 1];
            if (i > 0) {
                tdim.append(",");
            }
            tdim.append(dim);
        }
        tdim.append(")");
        if (size == 2 && desc == 'J' && (colTform = myHeader.getStringValue("TFORM" + (col + 1))) != null && (colTform.length() > 1 && colTform.charAt(0) == 'P' || colTform.length() > 2 && colTform.substring(0, 2).equals("1P"))) {
            return;
        }
        myHeader.addStringValue("TFORM" + (col + 1), "" + size + desc, null);
        myHeader.addStringValue("TDIM" + (col + 1), new String(tdim), null);
    }
}

