/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.browser.Convert;

public class UTMCoordinate
extends RealTuple {
    public static RealType EASTING = RealType.getRealType("UTM_Easting", CommonUnit.meter);
    public static RealType NORTHING = RealType.getRealType("UTM_Northing", CommonUnit.meter);
    public static RealType ZONE = RealType.getRealType("UTM_Zone");
    public static RealType HEMISPHERE = RealType.getRealType("UTM_Hemisphere");
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    private Real easting;
    private Real northing;
    private Real altitude;
    private Real zone;
    private Real hemisphere;

    public UTMCoordinate() throws VisADException, RemoteException {
        this(Double.NaN, Double.NaN);
    }

    public UTMCoordinate(double east, double north) throws VisADException, RemoteException {
        this(east, north, 0.0);
    }

    public UTMCoordinate(double east, double north, double alt) throws VisADException, RemoteException {
        this(east, north, Double.NaN, 0);
    }

    public UTMCoordinate(double east, double north, double alt, int zone) throws VisADException, RemoteException {
        this(east, north, alt, zone, 0);
    }

    public UTMCoordinate(double east, double north, double alt, int zone, int hemi) throws VisADException, RemoteException {
        this(new Real(EASTING, east), new Real(NORTHING, north), new Real(RealType.Altitude, alt), zone == 0 ? new Real(ZONE) : new Real(ZONE, (double)zone), new Real(HEMISPHERE, (double)hemi));
    }

    public UTMCoordinate(Real east, Real north) throws VisADException, RemoteException {
        this(east, north, new Real(ZONE));
    }

    public UTMCoordinate(Real east, Real north, Real alt) throws VisADException, RemoteException {
        this(east, north, alt, new Real(ZONE, 0.0));
    }

    public UTMCoordinate(Real east, Real north, Real alt, Real zone) throws VisADException, RemoteException {
        this(east, north, alt, zone, new Real(HEMISPHERE, 0.0));
    }

    public UTMCoordinate(Real east, Real north, Real alt, Real zone, Real hemi) throws VisADException, RemoteException {
        this(east, north, alt, zone, hemi, null);
    }

    public UTMCoordinate(Real east, Real north, Real alt, Real zone, Real hemi, CoordinateSystem cs) throws VisADException, RemoteException {
        super(new RealTupleType(new RealType[]{EASTING, NORTHING, RealType.Altitude, ZONE, HEMISPHERE}), new Real[]{east, north, alt, zone, hemi}, cs);
        this.easting = east;
        this.northing = north;
        this.altitude = alt;
        this.zone = zone;
        this.hemisphere = hemi;
    }

    public Real getEasting() {
        return this.easting;
    }

    public Real getNorthing() {
        return this.northing;
    }

    public Real getAltitude() {
        return this.altitude;
    }

    public Real getZone() {
        return this.zone;
    }

    public Real getHemisphere() {
        return this.zone;
    }

    public double getEastingValue() {
        try {
            return this.easting.getValue(CommonUnit.meter);
        }
        catch (VisADException ve) {
            return this.easting.getValue();
        }
    }

    public double getNorthingValue() {
        try {
            return this.northing.getValue(CommonUnit.meter);
        }
        catch (VisADException ve) {
            return this.northing.getValue();
        }
    }

    public double getAltitudeValue() {
        try {
            return this.altitude.getValue(CommonUnit.meter);
        }
        catch (VisADException ve) {
            return this.altitude.getValue();
        }
    }

    public int getZoneValue() {
        return (int)this.zone.getValue();
    }

    public int getHemisphereValue() {
        return (int)this.hemisphere.getValue();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("East: ");
        try {
            buf.append(Convert.shortString(this.easting.getValue(CommonUnit.degree)));
        }
        catch (VisADException ve) {
            buf.append(Convert.shortString(this.easting.getValue()));
        }
        buf.append(" North: ");
        try {
            buf.append(Convert.shortString(this.northing.getValue(CommonUnit.degree)));
        }
        catch (VisADException ve) {
            buf.append(Convert.shortString(this.northing.getValue()));
        }
        buf.append(" Zone: ");
        buf.append(this.getZoneValue());
        buf.append(" Hemisphere: ");
        buf.append(this.getHemisphereValue() == 0 ? "Northern" : "Southern");
        return buf.toString();
    }
}

