/*
 * Decompiled with CFR 0.152.
 */
package thredds.viewer.gis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import thredds.datamodel.gis.AbstractGisFeature;
import thredds.viewer.ui.Renderer;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.util.prefs.ui.Debug;

public abstract class GisFeatureRenderer
implements Renderer {
    private Color color = Color.blue;
    protected ProjectionImpl displayProject = null;
    protected ArrayList shapeList = null;

    public abstract LatLonRect getPreferredArea();

    protected abstract List getFeatures();

    protected abstract ProjectionImpl getDataProjection();

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setProjection(ProjectionImpl project) {
        this.displayProject = project;
        this.shapeList = null;
    }

    public void draw(Graphics2D g, AffineTransform pixelAT) {
        g.setColor(this.color);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setStroke(new BasicStroke(0.0f));
        Rectangle2D clipRect = (Rectangle2D)g.getClip();
        Iterator siter = this.getShapes(g, pixelAT);
        while (siter.hasNext()) {
            Shape s = (Shape)siter.next();
            Rectangle2D shapeBounds = s.getBounds2D();
            if (!shapeBounds.intersects(clipRect)) continue;
            g.draw(s);
        }
    }

    protected Iterator getShapes(Graphics2D g, AffineTransform normal2device) {
        if (this.shapeList != null) {
            return this.shapeList.iterator();
        }
        if (Debug.isSet("projection/LatLonShift")) {
            System.out.println("projection/LatLonShift GisFeatureRenderer.getShapes called");
        }
        ProjectionImpl dataProject = this.getDataProjection();
        List featList = this.getFeatures();
        this.shapeList = new ArrayList(featList.size());
        for (AbstractGisFeature feature : featList) {
            Shape shape = dataProject == null ? feature.getShape() : (dataProject.isLatLon() ? feature.getProjectedShape(this.displayProject) : (dataProject == this.displayProject ? feature.getShape() : feature.getProjectedShape(dataProject, this.displayProject)));
            this.shapeList.add(shape);
        }
        return this.shapeList.iterator();
    }
}

