/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.io.File;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataset;
import visad.data.hdf5.hdf5objects.HDF5Datatype;
import visad.data.hdf5.hdf5objects.HDF5Group;
import visad.data.hdf5.hdf5objects.HDF5Object;
import visad.data.hdf5.hdf5objects.HDF5TreeNode;

public class HDF5File
extends HDF5Object {
    public HDF5File(String filename, int flags, int create_id, int access_id) throws HDF5Exception {
        super(filename);
        this.type = 6;
        try {
            this.id = H5.H5Fcreate(filename, flags, create_id, access_id);
        }
        catch (HDF5Exception e) {
            this.id = -1;
            throw new HDF5Exception("HDF5File: " + e);
        }
    }

    public HDF5File(String filename, int flags, int access_id) throws HDF5Exception {
        super(filename);
        this.type = 6;
        try {
            this.id = H5.H5Fopen(filename, flags, access_id);
        }
        catch (HDF5Exception e) {
            this.id = -1;
            throw new HDF5Exception("HDF5File: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            H5.H5Fclose(this.id);
        }
    }

    public HDF5TreeNode loadTree() {
        int file;
        HDF5TreeNode root = null;
        try {
            file = H5.H5Fopen(this.name, 1, -2);
        }
        catch (HDF5Exception ex) {
            System.err.println("H5Fopen failed " + ex);
            return root;
        }
        HDF5Group rootGroup = new HDF5Group(file, "/");
        rootGroup.setShortName(new File(this.name).getName());
        root = new HDF5TreeNode(rootGroup);
        this.depth_first(file, "/", root);
        try {
            int ret = H5.H5Fclose(file);
        }
        catch (HDF5Exception ex) {
            System.err.println("H5Fopen failed " + ex);
            return root;
        }
        return root;
    }

    private boolean depth_first(int pid, String gname, HDF5TreeNode pnode) {
        int nelems = 0;
        int[] oType = new int[1];
        String[] oName = new String[]{new String(" ")};
        HDF5Group pObject = (HDF5Group)pnode.getUserObject();
        String pPath = pObject.getName();
        if (pPath.length() > 1) {
            pPath = pPath + "/";
        }
        nelems = 0;
        try {
            nelems = H5.H5Gn_members(pid, gname);
        }
        catch (HDF5Exception ex) {
            System.err.println("HDF5File.depth_first(): H5Gn_members() Failed, " + ex);
            return false;
        }
        if (nelems < 0) {
            return false;
        }
        for (int i = 0; i < nelems; ++i) {
            int ret;
            try {
                ret = H5.H5Gget_obj_info_idx(pid, gname, i, oName, oType);
            }
            catch (HDF5Exception ex) {
                System.err.println("HDF5File.depth_first(): H5Gn_members() Failed, " + ex);
                return false;
            }
            if (ret < 0) continue;
            switch (oType[0]) {
                case 1: {
                    HDF5Group g = new HDF5Group(pid, pPath + oName[0]);
                    g.setParent(pObject);
                    pObject.addMember(g);
                    HDF5TreeNode node = new HDF5TreeNode(g);
                    pnode.add(node);
                    int pgroup = -1;
                    try {
                        pgroup = H5.H5Gopen(pid, gname);
                    }
                    catch (HDF5Exception ex) {
                        System.err.println("HDF5File.depth_first(): H5Gopen() Failed, " + ex);
                        break;
                    }
                    this.depth_first(pgroup, oName[0], node);
                    break;
                }
                case 2: {
                    HDF5Dataset d = new HDF5Dataset(pid, pPath + oName[0]);
                    pObject.addMember(d);
                    HDF5TreeNode node = new HDF5TreeNode(d);
                    pnode.add(node);
                    break;
                }
                case 3: {
                    HDF5Datatype t = new HDF5Datatype(pid, pPath + oName[0]);
                    pObject.addMember(t);
                    HDF5TreeNode node = new HDF5TreeNode(t);
                    pnode.add(node);
                    break;
                }
                default: {
                    HDF5Object o = new HDF5Object(pPath + oName[0]);
                    pObject.addMember(o);
                    HDF5TreeNode node = new HDF5TreeNode(o);
                    pnode.add(node);
                }
            }
            oName[0] = null;
            oType[0] = -1;
        }
        return true;
    }
}

