/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDoubleArray;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryRealTuple
implements BinaryObject {
    public static final int computeBytes(Real[] components, CoordinateSystem cs, boolean trivialTuple) {
        int compsLen;
        if (components == null) {
            compsLen = 0;
        } else if (trivialTuple) {
            compsLen = 5 + components.length * 8;
        } else {
            compsLen = 5;
            for (int i = 0; i < components.length; ++i) {
                compsLen += BinaryReal.computeBytes(components[i].getUnit(), components[i].getError());
            }
        }
        return 10 + compsLen + (cs == null ? 0 : 5) + 1;
    }

    public static final boolean isTrivialTuple(RealTupleType type, Real[] components) {
        if (components == null) {
            return true;
        }
        for (int i = 0; i < components.length; ++i) {
            MathType comp;
            if (components[i] == null) continue;
            try {
                comp = type.getComponent(i);
            }
            catch (VisADException ve) {
                return false;
            }
            if (comp.equals(components[i].getType()) && components[i].getUnit() == null && components[i].getError() == null) continue;
            return false;
        }
        return true;
    }

    public static final RealTuple read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        RealTupleType rtt = (RealTupleType)typeCache.get(typeIndex);
        Real[] components = null;
        double[] values = null;
        CoordinateSystem cs = null;
        boolean reading = true;
        block8: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block8;
                }
                case 9: {
                    components = BinaryRealTuple.readRealArray(reader);
                    continue block8;
                }
                case 10: {
                    values = BinaryDoubleArray.read(reader);
                    continue block8;
                }
                case 80: {
                    reading = false;
                    continue block8;
                }
            }
            throw new IOException("Unknown RealTuple directive " + directive);
        }
        if (components != null && values != null) {
            throw new IOException("Found both RealTuple Real[] and double[] values");
        }
        if (values != null) {
            if (cs == null) {
                return new RealTuple(rtt, values);
            }
            components = new Real[values.length];
            for (int i = 0; i < values.length; ++i) {
                components[i] = new Real((RealType)rtt.getComponent(i), values[i], null, null);
            }
        }
        return new RealTuple(rtt, components, cs);
    }

    private static final Real[] readRealArray(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad Real array length " + len + ")");
        }
        long t = 0L;
        Real[] array = new Real[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Real)BinaryGeneric.read(reader);
        }
        return array;
    }

    public static final void writeDependentData(BinaryWriter writer, RealTupleType type, Real[] components, CoordinateSystem cs, RealTuple rt, Object token) throws IOException {
        if (!(rt.getClass().equals(RealTuple.class) || rt instanceof RealTuple && rt instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        BinaryRealTupleType.write(writer, type, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                BinaryGeneric.write(writer, components[i], dependToken);
            }
        }
    }

    public static final void write(BinaryWriter writer, RealTupleType type, Real[] components, CoordinateSystem cs, RealTuple rt, Object token) throws IOException {
        BinaryRealTuple.writeDependentData(writer, type, components, cs, rt, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(rt.getClass().equals(RealTuple.class) || rt instanceof RealTuple && rt instanceof Saveable)) {
            BinaryUnknown.write(writer, rt, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("RealTupleType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        boolean trivialTuple = BinaryRealTuple.isTrivialTuple(type, components);
        int objLen = BinaryRealTuple.computeBytes(components, cs, trivialTuple);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(11);
        file.writeInt(typeIndex);
        if (components != null) {
            if (trivialTuple) {
                file.writeByte(10);
                file.writeInt(components.length);
                for (int i = 0; i < components.length; ++i) {
                    file.writeDouble(components[i].getValue());
                }
            } else {
                file.writeByte(9);
                file.writeInt(components.length);
                for (int i = 0; i < components.length; ++i) {
                    BinaryReal.write(writer, (RealType)components[i].getType(), components[i].getValue(), components[i].getUnit(), components[i].getError(), components[i], token);
                }
            }
        }
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        file.writeByte(80);
    }
}

